package zio.aws.fms.model
import scala.jdk.CollectionConverters.*
sealed trait ViolationReason {
  def unwrap: software.amazon.awssdk.services.fms.model.ViolationReason
}
object ViolationReason {
  def wrap(
      value: software.amazon.awssdk.services.fms.model.ViolationReason
  ): zio.aws.fms.model.ViolationReason = value match {
    case software.amazon.awssdk.services.fms.model.ViolationReason.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.WEB_ACL_MISSING_RULE_GROUP =>
      val r = WEB_ACL_MISSING_RULE_GROUP
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.RESOURCE_MISSING_WEB_ACL =>
      val r = RESOURCE_MISSING_WEB_ACL
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.RESOURCE_INCORRECT_WEB_ACL =>
      val r = RESOURCE_INCORRECT_WEB_ACL
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.RESOURCE_MISSING_SHIELD_PROTECTION =>
      val r = RESOURCE_MISSING_SHIELD_PROTECTION
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.RESOURCE_MISSING_WEB_ACL_OR_SHIELD_PROTECTION =>
      val r = RESOURCE_MISSING_WEB_ACL_OR_SHIELD_PROTECTION
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.RESOURCE_MISSING_SECURITY_GROUP =>
      val r = RESOURCE_MISSING_SECURITY_GROUP
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.RESOURCE_VIOLATES_AUDIT_SECURITY_GROUP =>
      val r = RESOURCE_VIOLATES_AUDIT_SECURITY_GROUP
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.SECURITY_GROUP_UNUSED =>
      val r = SECURITY_GROUP_UNUSED
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.SECURITY_GROUP_REDUNDANT =>
      val r = SECURITY_GROUP_REDUNDANT
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.FMS_CREATED_SECURITY_GROUP_EDITED =>
      val r = FMS_CREATED_SECURITY_GROUP_EDITED
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.MISSING_FIREWALL =>
      val r = MISSING_FIREWALL
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.MISSING_FIREWALL_SUBNET_IN_AZ =>
      val r = MISSING_FIREWALL_SUBNET_IN_AZ
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.MISSING_EXPECTED_ROUTE_TABLE =>
      val r = MISSING_EXPECTED_ROUTE_TABLE
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.NETWORK_FIREWALL_POLICY_MODIFIED =>
      val r = NETWORK_FIREWALL_POLICY_MODIFIED
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.FIREWALL_SUBNET_IS_OUT_OF_SCOPE =>
      val r = FIREWALL_SUBNET_IS_OUT_OF_SCOPE
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.INTERNET_GATEWAY_MISSING_EXPECTED_ROUTE =>
      val r = INTERNET_GATEWAY_MISSING_EXPECTED_ROUTE
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.FIREWALL_SUBNET_MISSING_EXPECTED_ROUTE =>
      val r = FIREWALL_SUBNET_MISSING_EXPECTED_ROUTE
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.UNEXPECTED_FIREWALL_ROUTES =>
      val r = UNEXPECTED_FIREWALL_ROUTES
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.UNEXPECTED_TARGET_GATEWAY_ROUTES =>
      val r = UNEXPECTED_TARGET_GATEWAY_ROUTES
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.TRAFFIC_INSPECTION_CROSSES_AZ_BOUNDARY =>
      val r = TRAFFIC_INSPECTION_CROSSES_AZ_BOUNDARY
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.INVALID_ROUTE_CONFIGURATION =>
      val r = INVALID_ROUTE_CONFIGURATION
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.MISSING_TARGET_GATEWAY =>
      val r = MISSING_TARGET_GATEWAY
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.INTERNET_TRAFFIC_NOT_INSPECTED =>
      val r = INTERNET_TRAFFIC_NOT_INSPECTED
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.BLACK_HOLE_ROUTE_DETECTED =>
      val r = BLACK_HOLE_ROUTE_DETECTED
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.BLACK_HOLE_ROUTE_DETECTED_IN_FIREWALL_SUBNET =>
      val r = BLACK_HOLE_ROUTE_DETECTED_IN_FIREWALL_SUBNET
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.RESOURCE_MISSING_DNS_FIREWALL =>
      val r = RESOURCE_MISSING_DNS_FIREWALL
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.ROUTE_HAS_OUT_OF_SCOPE_ENDPOINT =>
      val r = ROUTE_HAS_OUT_OF_SCOPE_ENDPOINT
      r
    case software.amazon.awssdk.services.fms.model.ViolationReason.FIREWALL_SUBNET_MISSING_VPCE_ENDPOINT =>
      val r = FIREWALL_SUBNET_MISSING_VPCE_ENDPOINT
      r
  }
  case object unknownToSdkVersion extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.UNKNOWN_TO_SDK_VERSION
  }
  case object WEB_ACL_MISSING_RULE_GROUP
      extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.WEB_ACL_MISSING_RULE_GROUP
  }
  case object RESOURCE_MISSING_WEB_ACL
      extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.RESOURCE_MISSING_WEB_ACL
  }
  case object RESOURCE_INCORRECT_WEB_ACL
      extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.RESOURCE_INCORRECT_WEB_ACL
  }
  case object RESOURCE_MISSING_SHIELD_PROTECTION
      extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.RESOURCE_MISSING_SHIELD_PROTECTION
  }
  case object RESOURCE_MISSING_WEB_ACL_OR_SHIELD_PROTECTION
      extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.RESOURCE_MISSING_WEB_ACL_OR_SHIELD_PROTECTION
  }
  case object RESOURCE_MISSING_SECURITY_GROUP
      extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.RESOURCE_MISSING_SECURITY_GROUP
  }
  case object RESOURCE_VIOLATES_AUDIT_SECURITY_GROUP
      extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.RESOURCE_VIOLATES_AUDIT_SECURITY_GROUP
  }
  case object SECURITY_GROUP_UNUSED extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.SECURITY_GROUP_UNUSED
  }
  case object SECURITY_GROUP_REDUNDANT
      extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.SECURITY_GROUP_REDUNDANT
  }
  case object FMS_CREATED_SECURITY_GROUP_EDITED
      extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.FMS_CREATED_SECURITY_GROUP_EDITED
  }
  case object MISSING_FIREWALL extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.MISSING_FIREWALL
  }
  case object MISSING_FIREWALL_SUBNET_IN_AZ
      extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.MISSING_FIREWALL_SUBNET_IN_AZ
  }
  case object MISSING_EXPECTED_ROUTE_TABLE
      extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.MISSING_EXPECTED_ROUTE_TABLE
  }
  case object NETWORK_FIREWALL_POLICY_MODIFIED
      extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.NETWORK_FIREWALL_POLICY_MODIFIED
  }
  case object FIREWALL_SUBNET_IS_OUT_OF_SCOPE
      extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.FIREWALL_SUBNET_IS_OUT_OF_SCOPE
  }
  case object INTERNET_GATEWAY_MISSING_EXPECTED_ROUTE
      extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.INTERNET_GATEWAY_MISSING_EXPECTED_ROUTE
  }
  case object FIREWALL_SUBNET_MISSING_EXPECTED_ROUTE
      extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.FIREWALL_SUBNET_MISSING_EXPECTED_ROUTE
  }
  case object UNEXPECTED_FIREWALL_ROUTES
      extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.UNEXPECTED_FIREWALL_ROUTES
  }
  case object UNEXPECTED_TARGET_GATEWAY_ROUTES
      extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.UNEXPECTED_TARGET_GATEWAY_ROUTES
  }
  case object TRAFFIC_INSPECTION_CROSSES_AZ_BOUNDARY
      extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.TRAFFIC_INSPECTION_CROSSES_AZ_BOUNDARY
  }
  case object INVALID_ROUTE_CONFIGURATION
      extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.INVALID_ROUTE_CONFIGURATION
  }
  case object MISSING_TARGET_GATEWAY extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.MISSING_TARGET_GATEWAY
  }
  case object INTERNET_TRAFFIC_NOT_INSPECTED
      extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.INTERNET_TRAFFIC_NOT_INSPECTED
  }
  case object BLACK_HOLE_ROUTE_DETECTED
      extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.BLACK_HOLE_ROUTE_DETECTED
  }
  case object BLACK_HOLE_ROUTE_DETECTED_IN_FIREWALL_SUBNET
      extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.BLACK_HOLE_ROUTE_DETECTED_IN_FIREWALL_SUBNET
  }
  case object RESOURCE_MISSING_DNS_FIREWALL
      extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.RESOURCE_MISSING_DNS_FIREWALL
  }
  case object ROUTE_HAS_OUT_OF_SCOPE_ENDPOINT
      extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.ROUTE_HAS_OUT_OF_SCOPE_ENDPOINT
  }
  case object FIREWALL_SUBNET_MISSING_VPCE_ENDPOINT
      extends zio.aws.fms.model.ViolationReason {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ViolationReason =
      software.amazon.awssdk.services.fms.model.ViolationReason.FIREWALL_SUBNET_MISSING_VPCE_ENDPOINT
  }
}
