package zio.aws.forecast
import zio.aws.forecast.model.DescribePredictorResponse.ReadOnly
import zio.aws.forecast.model.{
  ListExplainabilitiesRequest,
  ResumeResourceRequest,
  DeleteForecastExportJobRequest,
  DescribeForecastExportJobRequest,
  CreateAutoPredictorRequest,
  CreateDatasetRequest,
  ListForecastsRequest,
  DescribeDatasetGroupRequest,
  ListPredictorsRequest,
  DeleteResourceTreeRequest,
  DeleteDatasetImportJobRequest,
  DeleteMonitorRequest,
  DeleteDatasetGroupRequest,
  ListMonitorEvaluationsRequest,
  CreatePredictorBacktestExportJobRequest,
  CreatePredictorRequest,
  DescribeDatasetRequest,
  ListTagsForResourceRequest,
  ListDatasetImportJobsRequest,
  DescribeDatasetImportJobRequest,
  CreateDatasetGroupRequest,
  ListDatasetsRequest,
  GetAccuracyMetricsRequest,
  DeleteExplainabilityExportRequest,
  DescribeExplainabilityExportRequest,
  DescribeMonitorRequest,
  ListMonitorsRequest,
  CreateExplainabilityRequest,
  DeleteForecastRequest,
  DeletePredictorRequest,
  DescribePredictorRequest,
  UpdateDatasetGroupRequest,
  CreateForecastExportJobRequest,
  DeleteDatasetRequest,
  ListForecastExportJobsRequest,
  StopResourceRequest,
  CreateExplainabilityExportRequest,
  UntagResourceRequest,
  ListDatasetGroupsRequest,
  DescribeForecastRequest,
  DescribeExplainabilityRequest,
  DescribePredictorBacktestExportJobRequest,
  CreateForecastRequest,
  DeleteExplainabilityRequest,
  DeletePredictorBacktestExportJobRequest,
  ListPredictorBacktestExportJobsRequest,
  ListExplainabilityExportsRequest,
  TagResourceRequest,
  CreateDatasetImportJobRequest,
  DescribeAutoPredictorRequest,
  CreateMonitorRequest
}
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.forecast.ForecastAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object ForecastMock extends Mock[Forecast] {
  object DescribeMonitor
      extends Effect[
        DescribeMonitorRequest,
        AwsError,
        zio.aws.forecast.model.DescribeMonitorResponse.ReadOnly
      ]
  object CreateDataset
      extends Effect[
        CreateDatasetRequest,
        AwsError,
        zio.aws.forecast.model.CreateDatasetResponse.ReadOnly
      ]
  object ListMonitors
      extends Stream[
        ListMonitorsRequest,
        AwsError,
        zio.aws.forecast.model.MonitorSummary.ReadOnly
      ]
  object ListMonitorsPaginated
      extends Effect[
        ListMonitorsRequest,
        AwsError,
        zio.aws.forecast.model.ListMonitorsResponse.ReadOnly
      ]
  object CreateDatasetGroup
      extends Effect[
        CreateDatasetGroupRequest,
        AwsError,
        zio.aws.forecast.model.CreateDatasetGroupResponse.ReadOnly
      ]
  object CreateExplainability
      extends Effect[
        CreateExplainabilityRequest,
        AwsError,
        zio.aws.forecast.model.CreateExplainabilityResponse.ReadOnly
      ]
  object CreatePredictor
      extends Effect[
        CreatePredictorRequest,
        AwsError,
        zio.aws.forecast.model.CreatePredictorResponse.ReadOnly
      ]
  object DeleteMonitor extends Effect[DeleteMonitorRequest, AwsError, Unit]
  object DeleteForecastExportJob
      extends Effect[DeleteForecastExportJobRequest, AwsError, Unit]
  object DescribeDatasetImportJob
      extends Effect[
        DescribeDatasetImportJobRequest,
        AwsError,
        zio.aws.forecast.model.DescribeDatasetImportJobResponse.ReadOnly
      ]
  object ListPredictorBacktestExportJobs
      extends Stream[
        ListPredictorBacktestExportJobsRequest,
        AwsError,
        zio.aws.forecast.model.PredictorBacktestExportJobSummary.ReadOnly
      ]
  object ListPredictorBacktestExportJobsPaginated
      extends Effect[
        ListPredictorBacktestExportJobsRequest,
        AwsError,
        zio.aws.forecast.model.ListPredictorBacktestExportJobsResponse.ReadOnly
      ]
  object CreateExplainabilityExport
      extends Effect[
        CreateExplainabilityExportRequest,
        AwsError,
        zio.aws.forecast.model.CreateExplainabilityExportResponse.ReadOnly
      ]
  object DescribeExplainabilityExport
      extends Effect[
        DescribeExplainabilityExportRequest,
        AwsError,
        zio.aws.forecast.model.DescribeExplainabilityExportResponse.ReadOnly
      ]
  object DescribeDataset
      extends Effect[
        DescribeDatasetRequest,
        AwsError,
        zio.aws.forecast.model.DescribeDatasetResponse.ReadOnly
      ]
  object CreateDatasetImportJob
      extends Effect[
        CreateDatasetImportJobRequest,
        AwsError,
        zio.aws.forecast.model.CreateDatasetImportJobResponse.ReadOnly
      ]
  object DeleteForecast extends Effect[DeleteForecastRequest, AwsError, Unit]
  object ListExplainabilities
      extends Stream[
        ListExplainabilitiesRequest,
        AwsError,
        zio.aws.forecast.model.ExplainabilitySummary.ReadOnly
      ]
  object ListExplainabilitiesPaginated
      extends Effect[
        ListExplainabilitiesRequest,
        AwsError,
        zio.aws.forecast.model.ListExplainabilitiesResponse.ReadOnly
      ]
  object DeleteResourceTree
      extends Effect[DeleteResourceTreeRequest, AwsError, Unit]
  object CreateMonitor
      extends Effect[
        CreateMonitorRequest,
        AwsError,
        zio.aws.forecast.model.CreateMonitorResponse.ReadOnly
      ]
  object CreateAutoPredictor
      extends Effect[
        CreateAutoPredictorRequest,
        AwsError,
        zio.aws.forecast.model.CreateAutoPredictorResponse.ReadOnly
      ]
  object DescribeForecastExportJob
      extends Effect[
        DescribeForecastExportJobRequest,
        AwsError,
        zio.aws.forecast.model.DescribeForecastExportJobResponse.ReadOnly
      ]
  object DeleteDatasetGroup
      extends Effect[DeleteDatasetGroupRequest, AwsError, Unit]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.forecast.model.UntagResourceResponse.ReadOnly
      ]
  object DescribeExplainability
      extends Effect[
        DescribeExplainabilityRequest,
        AwsError,
        zio.aws.forecast.model.DescribeExplainabilityResponse.ReadOnly
      ]
  object ListForecastExportJobs
      extends Stream[
        ListForecastExportJobsRequest,
        AwsError,
        zio.aws.forecast.model.ForecastExportJobSummary.ReadOnly
      ]
  object ListForecastExportJobsPaginated
      extends Effect[
        ListForecastExportJobsRequest,
        AwsError,
        zio.aws.forecast.model.ListForecastExportJobsResponse.ReadOnly
      ]
  object DeleteExplainability
      extends Effect[DeleteExplainabilityRequest, AwsError, Unit]
  object ListExplainabilityExports
      extends Stream[
        ListExplainabilityExportsRequest,
        AwsError,
        zio.aws.forecast.model.ExplainabilityExportSummary.ReadOnly
      ]
  object ListExplainabilityExportsPaginated
      extends Effect[
        ListExplainabilityExportsRequest,
        AwsError,
        zio.aws.forecast.model.ListExplainabilityExportsResponse.ReadOnly
      ]
  object ListDatasetGroups
      extends Stream[
        ListDatasetGroupsRequest,
        AwsError,
        zio.aws.forecast.model.DatasetGroupSummary.ReadOnly
      ]
  object ListDatasetGroupsPaginated
      extends Effect[
        ListDatasetGroupsRequest,
        AwsError,
        zio.aws.forecast.model.ListDatasetGroupsResponse.ReadOnly
      ]
  object DeleteDatasetImportJob
      extends Effect[DeleteDatasetImportJobRequest, AwsError, Unit]
  object StopResource extends Effect[StopResourceRequest, AwsError, Unit]
  object DescribePredictorBacktestExportJob
      extends Effect[
        DescribePredictorBacktestExportJobRequest,
        AwsError,
        zio.aws.forecast.model.DescribePredictorBacktestExportJobResponse.ReadOnly
      ]
  object DescribeDatasetGroup
      extends Effect[
        DescribeDatasetGroupRequest,
        AwsError,
        zio.aws.forecast.model.DescribeDatasetGroupResponse.ReadOnly
      ]
  object CreateForecast
      extends Effect[
        CreateForecastRequest,
        AwsError,
        zio.aws.forecast.model.CreateForecastResponse.ReadOnly
      ]
  object ListForecasts
      extends Stream[
        ListForecastsRequest,
        AwsError,
        zio.aws.forecast.model.ForecastSummary.ReadOnly
      ]
  object ListForecastsPaginated
      extends Effect[
        ListForecastsRequest,
        AwsError,
        zio.aws.forecast.model.ListForecastsResponse.ReadOnly
      ]
  object ListPredictors
      extends Stream[
        ListPredictorsRequest,
        AwsError,
        zio.aws.forecast.model.PredictorSummary.ReadOnly
      ]
  object ListPredictorsPaginated
      extends Effect[
        ListPredictorsRequest,
        AwsError,
        zio.aws.forecast.model.ListPredictorsResponse.ReadOnly
      ]
  object ResumeResource extends Effect[ResumeResourceRequest, AwsError, Unit]
  object DeletePredictorBacktestExportJob
      extends Effect[DeletePredictorBacktestExportJobRequest, AwsError, Unit]
  object CreateForecastExportJob
      extends Effect[
        CreateForecastExportJobRequest,
        AwsError,
        zio.aws.forecast.model.CreateForecastExportJobResponse.ReadOnly
      ]
  object ListDatasets
      extends Stream[
        ListDatasetsRequest,
        AwsError,
        zio.aws.forecast.model.DatasetSummary.ReadOnly
      ]
  object ListDatasetsPaginated
      extends Effect[
        ListDatasetsRequest,
        AwsError,
        zio.aws.forecast.model.ListDatasetsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.forecast.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DeleteExplainabilityExport
      extends Effect[DeleteExplainabilityExportRequest, AwsError, Unit]
  object DeletePredictor extends Effect[DeletePredictorRequest, AwsError, Unit]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.forecast.model.TagResourceResponse.ReadOnly
      ]
  object ListDatasetImportJobs
      extends Stream[
        ListDatasetImportJobsRequest,
        AwsError,
        zio.aws.forecast.model.DatasetImportJobSummary.ReadOnly
      ]
  object ListDatasetImportJobsPaginated
      extends Effect[
        ListDatasetImportJobsRequest,
        AwsError,
        zio.aws.forecast.model.ListDatasetImportJobsResponse.ReadOnly
      ]
  object DescribeAutoPredictor
      extends Effect[
        DescribeAutoPredictorRequest,
        AwsError,
        zio.aws.forecast.model.DescribeAutoPredictorResponse.ReadOnly
      ]
  object DescribeForecast
      extends Effect[
        DescribeForecastRequest,
        AwsError,
        zio.aws.forecast.model.DescribeForecastResponse.ReadOnly
      ]
  object ListMonitorEvaluations
      extends Stream[
        ListMonitorEvaluationsRequest,
        AwsError,
        zio.aws.forecast.model.PredictorMonitorEvaluation.ReadOnly
      ]
  object ListMonitorEvaluationsPaginated
      extends Effect[
        ListMonitorEvaluationsRequest,
        AwsError,
        zio.aws.forecast.model.ListMonitorEvaluationsResponse.ReadOnly
      ]
  object DeleteDataset extends Effect[DeleteDatasetRequest, AwsError, Unit]
  object CreatePredictorBacktestExportJob
      extends Effect[
        CreatePredictorBacktestExportJobRequest,
        AwsError,
        zio.aws.forecast.model.CreatePredictorBacktestExportJobResponse.ReadOnly
      ]
  object UpdateDatasetGroup
      extends Effect[
        UpdateDatasetGroupRequest,
        AwsError,
        zio.aws.forecast.model.UpdateDatasetGroupResponse.ReadOnly
      ]
  object GetAccuracyMetrics
      extends Effect[
        GetAccuracyMetricsRequest,
        AwsError,
        zio.aws.forecast.model.GetAccuracyMetricsResponse.ReadOnly
      ]
  object DescribePredictor
      extends Effect[DescribePredictorRequest, AwsError, ReadOnly]
  val compose: URLayer[Proxy, Forecast] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Forecast] { rts =>
        zio.ZIO.succeed {
          new Forecast {
            val api: ForecastAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Forecast = this
            def describeMonitor(request: DescribeMonitorRequest): IO[
              AwsError,
              zio.aws.forecast.model.DescribeMonitorResponse.ReadOnly
            ] = proxy(DescribeMonitor, request)
            def createDataset(request: CreateDatasetRequest): IO[
              AwsError,
              zio.aws.forecast.model.CreateDatasetResponse.ReadOnly
            ] = proxy(CreateDataset, request)
            def listMonitors(request: ListMonitorsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.forecast.model.MonitorSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListMonitors, request))
            def listMonitorsPaginated(request: ListMonitorsRequest): IO[
              AwsError,
              zio.aws.forecast.model.ListMonitorsResponse.ReadOnly
            ] = proxy(ListMonitorsPaginated, request)
            def createDatasetGroup(request: CreateDatasetGroupRequest): IO[
              AwsError,
              zio.aws.forecast.model.CreateDatasetGroupResponse.ReadOnly
            ] = proxy(CreateDatasetGroup, request)
            def createExplainability(request: CreateExplainabilityRequest): IO[
              AwsError,
              zio.aws.forecast.model.CreateExplainabilityResponse.ReadOnly
            ] = proxy(CreateExplainability, request)
            def createPredictor(request: CreatePredictorRequest): IO[
              AwsError,
              zio.aws.forecast.model.CreatePredictorResponse.ReadOnly
            ] = proxy(CreatePredictor, request)
            def deleteMonitor(
                request: DeleteMonitorRequest
            ): IO[AwsError, Unit] = proxy(DeleteMonitor, request)
            def deleteForecastExportJob(
                request: DeleteForecastExportJobRequest
            ): IO[AwsError, Unit] = proxy(DeleteForecastExportJob, request)
            def describeDatasetImportJob(
                request: DescribeDatasetImportJobRequest
            ): IO[
              AwsError,
              zio.aws.forecast.model.DescribeDatasetImportJobResponse.ReadOnly
            ] = proxy(DescribeDatasetImportJob, request)
            def listPredictorBacktestExportJobs(
                request: ListPredictorBacktestExportJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.forecast.model.PredictorBacktestExportJobSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListPredictorBacktestExportJobs, request))
            def listPredictorBacktestExportJobsPaginated(
                request: ListPredictorBacktestExportJobsRequest
            ): IO[
              AwsError,
              zio.aws.forecast.model.ListPredictorBacktestExportJobsResponse.ReadOnly
            ] = proxy(ListPredictorBacktestExportJobsPaginated, request)
            def createExplainabilityExport(
                request: CreateExplainabilityExportRequest
            ): IO[
              AwsError,
              zio.aws.forecast.model.CreateExplainabilityExportResponse.ReadOnly
            ] = proxy(CreateExplainabilityExport, request)
            def describeExplainabilityExport(
                request: DescribeExplainabilityExportRequest
            ): IO[
              AwsError,
              zio.aws.forecast.model.DescribeExplainabilityExportResponse.ReadOnly
            ] = proxy(DescribeExplainabilityExport, request)
            def describeDataset(request: DescribeDatasetRequest): IO[
              AwsError,
              zio.aws.forecast.model.DescribeDatasetResponse.ReadOnly
            ] = proxy(DescribeDataset, request)
            def createDatasetImportJob(
                request: CreateDatasetImportJobRequest
            ): IO[
              AwsError,
              zio.aws.forecast.model.CreateDatasetImportJobResponse.ReadOnly
            ] = proxy(CreateDatasetImportJob, request)
            def deleteForecast(
                request: DeleteForecastRequest
            ): IO[AwsError, Unit] = proxy(DeleteForecast, request)
            def listExplainabilities(
                request: ListExplainabilitiesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.forecast.model.ExplainabilitySummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListExplainabilities, request))
            def listExplainabilitiesPaginated(
                request: ListExplainabilitiesRequest
            ): IO[
              AwsError,
              zio.aws.forecast.model.ListExplainabilitiesResponse.ReadOnly
            ] = proxy(ListExplainabilitiesPaginated, request)
            def deleteResourceTree(
                request: DeleteResourceTreeRequest
            ): IO[AwsError, Unit] = proxy(DeleteResourceTree, request)
            def createMonitor(request: CreateMonitorRequest): IO[
              AwsError,
              zio.aws.forecast.model.CreateMonitorResponse.ReadOnly
            ] = proxy(CreateMonitor, request)
            def createAutoPredictor(request: CreateAutoPredictorRequest): IO[
              AwsError,
              zio.aws.forecast.model.CreateAutoPredictorResponse.ReadOnly
            ] = proxy(CreateAutoPredictor, request)
            def describeForecastExportJob(
                request: DescribeForecastExportJobRequest
            ): IO[
              AwsError,
              zio.aws.forecast.model.DescribeForecastExportJobResponse.ReadOnly
            ] = proxy(DescribeForecastExportJob, request)
            def deleteDatasetGroup(
                request: DeleteDatasetGroupRequest
            ): IO[AwsError, Unit] = proxy(DeleteDatasetGroup, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.forecast.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def describeExplainability(
                request: DescribeExplainabilityRequest
            ): IO[
              AwsError,
              zio.aws.forecast.model.DescribeExplainabilityResponse.ReadOnly
            ] = proxy(DescribeExplainability, request)
            def listForecastExportJobs(
                request: ListForecastExportJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.forecast.model.ForecastExportJobSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListForecastExportJobs, request))
            def listForecastExportJobsPaginated(
                request: ListForecastExportJobsRequest
            ): IO[
              AwsError,
              zio.aws.forecast.model.ListForecastExportJobsResponse.ReadOnly
            ] = proxy(ListForecastExportJobsPaginated, request)
            def deleteExplainability(
                request: DeleteExplainabilityRequest
            ): IO[AwsError, Unit] = proxy(DeleteExplainability, request)
            def listExplainabilityExports(
                request: ListExplainabilityExportsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.forecast.model.ExplainabilityExportSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListExplainabilityExports, request))
            def listExplainabilityExportsPaginated(
                request: ListExplainabilityExportsRequest
            ): IO[
              AwsError,
              zio.aws.forecast.model.ListExplainabilityExportsResponse.ReadOnly
            ] = proxy(ListExplainabilityExportsPaginated, request)
            def listDatasetGroups(request: ListDatasetGroupsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.forecast.model.DatasetGroupSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListDatasetGroups, request))
            def listDatasetGroupsPaginated(
                request: ListDatasetGroupsRequest
            ): IO[
              AwsError,
              zio.aws.forecast.model.ListDatasetGroupsResponse.ReadOnly
            ] = proxy(ListDatasetGroupsPaginated, request)
            def deleteDatasetImportJob(
                request: DeleteDatasetImportJobRequest
            ): IO[AwsError, Unit] = proxy(DeleteDatasetImportJob, request)
            def stopResource(request: StopResourceRequest): IO[AwsError, Unit] =
              proxy(StopResource, request)
            def describePredictorBacktestExportJob(
                request: DescribePredictorBacktestExportJobRequest
            ): IO[
              AwsError,
              zio.aws.forecast.model.DescribePredictorBacktestExportJobResponse.ReadOnly
            ] = proxy(DescribePredictorBacktestExportJob, request)
            def describeDatasetGroup(request: DescribeDatasetGroupRequest): IO[
              AwsError,
              zio.aws.forecast.model.DescribeDatasetGroupResponse.ReadOnly
            ] = proxy(DescribeDatasetGroup, request)
            def createForecast(request: CreateForecastRequest): IO[
              AwsError,
              zio.aws.forecast.model.CreateForecastResponse.ReadOnly
            ] = proxy(CreateForecast, request)
            def listForecasts(request: ListForecastsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.forecast.model.ForecastSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListForecasts, request))
            def listForecastsPaginated(request: ListForecastsRequest): IO[
              AwsError,
              zio.aws.forecast.model.ListForecastsResponse.ReadOnly
            ] = proxy(ListForecastsPaginated, request)
            def listPredictors(request: ListPredictorsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.forecast.model.PredictorSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListPredictors, request))
            def listPredictorsPaginated(request: ListPredictorsRequest): IO[
              AwsError,
              zio.aws.forecast.model.ListPredictorsResponse.ReadOnly
            ] = proxy(ListPredictorsPaginated, request)
            def resumeResource(
                request: ResumeResourceRequest
            ): IO[AwsError, Unit] = proxy(ResumeResource, request)
            def deletePredictorBacktestExportJob(
                request: DeletePredictorBacktestExportJobRequest
            ): IO[AwsError, Unit] =
              proxy(DeletePredictorBacktestExportJob, request)
            def createForecastExportJob(
                request: CreateForecastExportJobRequest
            ): IO[
              AwsError,
              zio.aws.forecast.model.CreateForecastExportJobResponse.ReadOnly
            ] = proxy(CreateForecastExportJob, request)
            def listDatasets(request: ListDatasetsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.forecast.model.DatasetSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListDatasets, request))
            def listDatasetsPaginated(request: ListDatasetsRequest): IO[
              AwsError,
              zio.aws.forecast.model.ListDatasetsResponse.ReadOnly
            ] = proxy(ListDatasetsPaginated, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.forecast.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def deleteExplainabilityExport(
                request: DeleteExplainabilityExportRequest
            ): IO[AwsError, Unit] = proxy(DeleteExplainabilityExport, request)
            def deletePredictor(
                request: DeletePredictorRequest
            ): IO[AwsError, Unit] = proxy(DeletePredictor, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.forecast.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def listDatasetImportJobs(
                request: ListDatasetImportJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.forecast.model.DatasetImportJobSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListDatasetImportJobs, request))
            def listDatasetImportJobsPaginated(
                request: ListDatasetImportJobsRequest
            ): IO[
              AwsError,
              zio.aws.forecast.model.ListDatasetImportJobsResponse.ReadOnly
            ] = proxy(ListDatasetImportJobsPaginated, request)
            def describeAutoPredictor(
                request: DescribeAutoPredictorRequest
            ): IO[
              AwsError,
              zio.aws.forecast.model.DescribeAutoPredictorResponse.ReadOnly
            ] = proxy(DescribeAutoPredictor, request)
            def describeForecast(request: DescribeForecastRequest): IO[
              AwsError,
              zio.aws.forecast.model.DescribeForecastResponse.ReadOnly
            ] = proxy(DescribeForecast, request)
            def listMonitorEvaluations(
                request: ListMonitorEvaluationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.forecast.model.PredictorMonitorEvaluation.ReadOnly
            ] = rts.unsafeRun(proxy(ListMonitorEvaluations, request))
            def listMonitorEvaluationsPaginated(
                request: ListMonitorEvaluationsRequest
            ): IO[
              AwsError,
              zio.aws.forecast.model.ListMonitorEvaluationsResponse.ReadOnly
            ] = proxy(ListMonitorEvaluationsPaginated, request)
            def deleteDataset(
                request: DeleteDatasetRequest
            ): IO[AwsError, Unit] = proxy(DeleteDataset, request)
            def createPredictorBacktestExportJob(
                request: CreatePredictorBacktestExportJobRequest
            ): IO[
              AwsError,
              zio.aws.forecast.model.CreatePredictorBacktestExportJobResponse.ReadOnly
            ] = proxy(CreatePredictorBacktestExportJob, request)
            def updateDatasetGroup(request: UpdateDatasetGroupRequest): IO[
              AwsError,
              zio.aws.forecast.model.UpdateDatasetGroupResponse.ReadOnly
            ] = proxy(UpdateDatasetGroup, request)
            def getAccuracyMetrics(request: GetAccuracyMetricsRequest): IO[
              AwsError,
              zio.aws.forecast.model.GetAccuracyMetricsResponse.ReadOnly
            ] = proxy(GetAccuracyMetrics, request)
            def describePredictor(
                request: DescribePredictorRequest
            ): IO[AwsError, ReadOnly] = proxy(DescribePredictor, request)
          }
        }
      }
    }
  }
}
