package zio.aws.forecast.model
import scala.jdk.CollectionConverters._
sealed trait AttributeType {
  def unwrap: software.amazon.awssdk.services.forecast.model.AttributeType
}
object AttributeType {
  def wrap(
      value: software.amazon.awssdk.services.forecast.model.AttributeType
  ): zio.aws.forecast.model.AttributeType = value match {
    case software.amazon.awssdk.services.forecast.model.AttributeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.forecast.model.AttributeType.STRING =>
      val r = string
      r
    case software.amazon.awssdk.services.forecast.model.AttributeType.INTEGER =>
      val r = integer
      r
    case software.amazon.awssdk.services.forecast.model.AttributeType.FLOAT =>
      val r = float
      r
    case software.amazon.awssdk.services.forecast.model.AttributeType.TIMESTAMP =>
      val r = timestamp
      r
    case software.amazon.awssdk.services.forecast.model.AttributeType.GEOLOCATION =>
      val r = geolocation
      r
  }
  case object unknownToSdkVersion extends zio.aws.forecast.model.AttributeType {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.AttributeType =
      software.amazon.awssdk.services.forecast.model.AttributeType.UNKNOWN_TO_SDK_VERSION
  }
  case object string extends zio.aws.forecast.model.AttributeType {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.AttributeType =
      software.amazon.awssdk.services.forecast.model.AttributeType.STRING
  }
  case object integer extends zio.aws.forecast.model.AttributeType {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.AttributeType =
      software.amazon.awssdk.services.forecast.model.AttributeType.INTEGER
  }
  case object float extends zio.aws.forecast.model.AttributeType {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.AttributeType =
      software.amazon.awssdk.services.forecast.model.AttributeType.FLOAT
  }
  case object timestamp extends zio.aws.forecast.model.AttributeType {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.AttributeType =
      software.amazon.awssdk.services.forecast.model.AttributeType.TIMESTAMP
  }
  case object geolocation extends zio.aws.forecast.model.AttributeType {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.AttributeType =
      software.amazon.awssdk.services.forecast.model.AttributeType.GEOLOCATION
  }
}
