package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{
  Frequency,
  ForecastType,
  Arn,
  Integer,
  Name
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAutoPredictorRequest(
    predictorName: Name,
    forecastHorizon: Optional[Integer] = Optional.Absent,
    forecastTypes: Optional[Iterable[ForecastType]] = Optional.Absent,
    forecastDimensions: Optional[Iterable[Name]] = Optional.Absent,
    forecastFrequency: Optional[Frequency] = Optional.Absent,
    dataConfig: Optional[zio.aws.forecast.model.DataConfig] = Optional.Absent,
    encryptionConfig: Optional[zio.aws.forecast.model.EncryptionConfig] =
      Optional.Absent,
    referencePredictorArn: Optional[Arn] = Optional.Absent,
    optimizationMetric: Optional[zio.aws.forecast.model.OptimizationMetric] =
      Optional.Absent,
    explainPredictor: Optional[Boolean] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.forecast.model.Tag]] = Optional.Absent,
    monitorConfig: Optional[zio.aws.forecast.model.MonitorConfig] =
      Optional.Absent,
    timeAlignmentBoundary: Optional[
      zio.aws.forecast.model.TimeAlignmentBoundary
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreateAutoPredictorRequest = {
    import CreateAutoPredictorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreateAutoPredictorRequest
      .builder()
      .predictorName(Name.unwrap(predictorName): java.lang.String)
      .optionallyWith(forecastHorizon.map(value => value: java.lang.Integer))(
        _.forecastHorizon
      )
      .optionallyWith(
        forecastTypes.map(value =>
          value.map { item =>
            ForecastType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.forecastTypes)
      .optionallyWith(
        forecastDimensions.map(value =>
          value.map { item =>
            Name.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.forecastDimensions)
      .optionallyWith(
        forecastFrequency.map(value =>
          Frequency.unwrap(value): java.lang.String
        )
      )(_.forecastFrequency)
      .optionallyWith(dataConfig.map(value => value.buildAwsValue()))(
        _.dataConfig
      )
      .optionallyWith(encryptionConfig.map(value => value.buildAwsValue()))(
        _.encryptionConfig
      )
      .optionallyWith(
        referencePredictorArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.referencePredictorArn)
      .optionallyWith(optimizationMetric.map(value => value.unwrap))(
        _.optimizationMetric
      )
      .optionallyWith(explainPredictor.map(value => value: java.lang.Boolean))(
        _.explainPredictor
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(monitorConfig.map(value => value.buildAwsValue()))(
        _.monitorConfig
      )
      .optionallyWith(
        timeAlignmentBoundary.map(value => value.buildAwsValue())
      )(_.timeAlignmentBoundary)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.CreateAutoPredictorRequest.ReadOnly =
    zio.aws.forecast.model.CreateAutoPredictorRequest.wrap(buildAwsValue())
}
object CreateAutoPredictorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreateAutoPredictorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreateAutoPredictorRequest =
      zio.aws.forecast.model.CreateAutoPredictorRequest(
        predictorName,
        forecastHorizon.map(value => value),
        forecastTypes.map(value => value),
        forecastDimensions.map(value => value),
        forecastFrequency.map(value => value),
        dataConfig.map(value => value.asEditable),
        encryptionConfig.map(value => value.asEditable),
        referencePredictorArn.map(value => value),
        optimizationMetric.map(value => value),
        explainPredictor.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        monitorConfig.map(value => value.asEditable),
        timeAlignmentBoundary.map(value => value.asEditable)
      )
    def predictorName: Name
    def forecastHorizon: Optional[Integer]
    def forecastTypes: Optional[List[ForecastType]]
    def forecastDimensions: Optional[List[Name]]
    def forecastFrequency: Optional[Frequency]
    def dataConfig: Optional[zio.aws.forecast.model.DataConfig.ReadOnly]
    def encryptionConfig
        : Optional[zio.aws.forecast.model.EncryptionConfig.ReadOnly]
    def referencePredictorArn: Optional[Arn]
    def optimizationMetric: Optional[zio.aws.forecast.model.OptimizationMetric]
    def explainPredictor: Optional[Boolean]
    def tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]]
    def monitorConfig: Optional[zio.aws.forecast.model.MonitorConfig.ReadOnly]
    def timeAlignmentBoundary
        : Optional[zio.aws.forecast.model.TimeAlignmentBoundary.ReadOnly]
    def getPredictorName: ZIO[Any, Nothing, Name] = ZIO.succeed(predictorName)
    def getForecastHorizon: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("forecastHorizon", forecastHorizon)
    def getForecastTypes: ZIO[Any, AwsError, List[ForecastType]] =
      AwsError.unwrapOptionField("forecastTypes", forecastTypes)
    def getForecastDimensions: ZIO[Any, AwsError, List[Name]] =
      AwsError.unwrapOptionField("forecastDimensions", forecastDimensions)
    def getForecastFrequency: ZIO[Any, AwsError, Frequency] =
      AwsError.unwrapOptionField("forecastFrequency", forecastFrequency)
    def getDataConfig
        : ZIO[Any, AwsError, zio.aws.forecast.model.DataConfig.ReadOnly] =
      AwsError.unwrapOptionField("dataConfig", dataConfig)
    def getEncryptionConfig
        : ZIO[Any, AwsError, zio.aws.forecast.model.EncryptionConfig.ReadOnly] =
      AwsError.unwrapOptionField("encryptionConfig", encryptionConfig)
    def getReferencePredictorArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("referencePredictorArn", referencePredictorArn)
    def getOptimizationMetric
        : ZIO[Any, AwsError, zio.aws.forecast.model.OptimizationMetric] =
      AwsError.unwrapOptionField("optimizationMetric", optimizationMetric)
    def getExplainPredictor: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("explainPredictor", explainPredictor)
    def getTags: ZIO[Any, AwsError, List[zio.aws.forecast.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getMonitorConfig
        : ZIO[Any, AwsError, zio.aws.forecast.model.MonitorConfig.ReadOnly] =
      AwsError.unwrapOptionField("monitorConfig", monitorConfig)
    def getTimeAlignmentBoundary: ZIO[
      Any,
      AwsError,
      zio.aws.forecast.model.TimeAlignmentBoundary.ReadOnly
    ] =
      AwsError.unwrapOptionField("timeAlignmentBoundary", timeAlignmentBoundary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreateAutoPredictorRequest
  ) extends zio.aws.forecast.model.CreateAutoPredictorRequest.ReadOnly {
    override val predictorName: Name =
      zio.aws.forecast.model.primitives.Name(impl.predictorName())
    override val forecastHorizon: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.forecastHorizon())
      .map(value => value: Integer)
    override val forecastTypes: Optional[List[ForecastType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forecastTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.primitives.ForecastType(item)
          }.toList
        )
    override val forecastDimensions: Optional[List[Name]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forecastDimensions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.primitives.Name(item)
          }.toList
        )
    override val forecastFrequency: Optional[Frequency] = zio.aws.core.internal
      .optionalFromNullable(impl.forecastFrequency())
      .map(value => zio.aws.forecast.model.primitives.Frequency(value))
    override val dataConfig
        : Optional[zio.aws.forecast.model.DataConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataConfig())
        .map(value => zio.aws.forecast.model.DataConfig.wrap(value))
    override val encryptionConfig
        : Optional[zio.aws.forecast.model.EncryptionConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionConfig())
        .map(value => zio.aws.forecast.model.EncryptionConfig.wrap(value))
    override val referencePredictorArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.referencePredictorArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val optimizationMetric
        : Optional[zio.aws.forecast.model.OptimizationMetric] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optimizationMetric())
        .map(value => zio.aws.forecast.model.OptimizationMetric.wrap(value))
    override val explainPredictor: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.explainPredictor())
      .map(value => value: Boolean)
    override val tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.Tag.wrap(item)
          }.toList
        )
    override val monitorConfig
        : Optional[zio.aws.forecast.model.MonitorConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitorConfig())
        .map(value => zio.aws.forecast.model.MonitorConfig.wrap(value))
    override val timeAlignmentBoundary
        : Optional[zio.aws.forecast.model.TimeAlignmentBoundary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeAlignmentBoundary())
        .map(value => zio.aws.forecast.model.TimeAlignmentBoundary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreateAutoPredictorRequest
  ): zio.aws.forecast.model.CreateAutoPredictorRequest.ReadOnly = new Wrapper(
    impl
  )
}
