package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDatasetResponse(
    datasetArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreateDatasetResponse = {
    import CreateDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreateDatasetResponse
      .builder()
      .optionallyWith(
        datasetArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.CreateDatasetResponse.ReadOnly =
    zio.aws.forecast.model.CreateDatasetResponse.wrap(buildAwsValue())
}
object CreateDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreateDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreateDatasetResponse =
      zio.aws.forecast.model
        .CreateDatasetResponse(datasetArn.map(value => value))
    def datasetArn: Optional[Arn]
    def getDatasetArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreateDatasetResponse
  ) extends zio.aws.forecast.model.CreateDatasetResponse.ReadOnly {
    override val datasetArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreateDatasetResponse
  ): zio.aws.forecast.model.CreateDatasetResponse.ReadOnly = new Wrapper(impl)
}
