package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateExplainabilityExportResponse(
    explainabilityExportArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreateExplainabilityExportResponse = {
    import CreateExplainabilityExportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreateExplainabilityExportResponse
      .builder()
      .optionallyWith(
        explainabilityExportArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.explainabilityExportArn)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.CreateExplainabilityExportResponse.ReadOnly =
    zio.aws.forecast.model.CreateExplainabilityExportResponse
      .wrap(buildAwsValue())
}
object CreateExplainabilityExportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreateExplainabilityExportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreateExplainabilityExportResponse =
      zio.aws.forecast.model.CreateExplainabilityExportResponse(
        explainabilityExportArn.map(value => value)
      )
    def explainabilityExportArn: Optional[Arn]
    def getExplainabilityExportArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("explainabilityExportArn", explainabilityExportArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreateExplainabilityExportResponse
  ) extends zio.aws.forecast.model.CreateExplainabilityExportResponse.ReadOnly {
    override val explainabilityExportArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.explainabilityExportArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreateExplainabilityExportResponse
  ): zio.aws.forecast.model.CreateExplainabilityExportResponse.ReadOnly =
    new Wrapper(impl)
}
