package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateExplainabilityResponse(
    explainabilityArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreateExplainabilityResponse = {
    import CreateExplainabilityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreateExplainabilityResponse
      .builder()
      .optionallyWith(
        explainabilityArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.explainabilityArn)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.CreateExplainabilityResponse.ReadOnly =
    zio.aws.forecast.model.CreateExplainabilityResponse.wrap(buildAwsValue())
}
object CreateExplainabilityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreateExplainabilityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreateExplainabilityResponse =
      zio.aws.forecast.model
        .CreateExplainabilityResponse(explainabilityArn.map(value => value))
    def explainabilityArn: Optional[Arn]
    def getExplainabilityArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("explainabilityArn", explainabilityArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreateExplainabilityResponse
  ) extends zio.aws.forecast.model.CreateExplainabilityResponse.ReadOnly {
    override val explainabilityArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.explainabilityArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreateExplainabilityResponse
  ): zio.aws.forecast.model.CreateExplainabilityResponse.ReadOnly = new Wrapper(
    impl
  )
}
