package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{
  ParameterKey,
  ParameterValue,
  ForecastType,
  Arn,
  Integer,
  Name
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreatePredictorRequest(
    predictorName: Name,
    algorithmArn: Optional[Arn] = Optional.Absent,
    forecastHorizon: Integer,
    forecastTypes: Optional[Iterable[ForecastType]] = Optional.Absent,
    performAutoML: Optional[Boolean] = Optional.Absent,
    autoMLOverrideStrategy: Optional[
      zio.aws.forecast.model.AutoMLOverrideStrategy
    ] = Optional.Absent,
    performHPO: Optional[Boolean] = Optional.Absent,
    trainingParameters: Optional[Map[ParameterKey, ParameterValue]] =
      Optional.Absent,
    evaluationParameters: Optional[
      zio.aws.forecast.model.EvaluationParameters
    ] = Optional.Absent,
    hpoConfig: Optional[zio.aws.forecast.model.HyperParameterTuningJobConfig] =
      Optional.Absent,
    inputDataConfig: zio.aws.forecast.model.InputDataConfig,
    featurizationConfig: zio.aws.forecast.model.FeaturizationConfig,
    encryptionConfig: Optional[zio.aws.forecast.model.EncryptionConfig] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.forecast.model.Tag]] = Optional.Absent,
    optimizationMetric: Optional[zio.aws.forecast.model.OptimizationMetric] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreatePredictorRequest = {
    import CreatePredictorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreatePredictorRequest
      .builder()
      .predictorName(Name.unwrap(predictorName): java.lang.String)
      .optionallyWith(
        algorithmArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.algorithmArn)
      .forecastHorizon(forecastHorizon: java.lang.Integer)
      .optionallyWith(
        forecastTypes.map(value =>
          value.map { item =>
            ForecastType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.forecastTypes)
      .optionallyWith(performAutoML.map(value => value: java.lang.Boolean))(
        _.performAutoML
      )
      .optionallyWith(autoMLOverrideStrategy.map(value => value.unwrap))(
        _.autoMLOverrideStrategy
      )
      .optionallyWith(performHPO.map(value => value: java.lang.Boolean))(
        _.performHPO
      )
      .optionallyWith(
        trainingParameters.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterKey.unwrap(key): java.lang.String) -> (ParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.trainingParameters)
      .optionallyWith(evaluationParameters.map(value => value.buildAwsValue()))(
        _.evaluationParameters
      )
      .optionallyWith(hpoConfig.map(value => value.buildAwsValue()))(
        _.hpoConfig
      )
      .inputDataConfig(inputDataConfig.buildAwsValue())
      .featurizationConfig(featurizationConfig.buildAwsValue())
      .optionallyWith(encryptionConfig.map(value => value.buildAwsValue()))(
        _.encryptionConfig
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(optimizationMetric.map(value => value.unwrap))(
        _.optimizationMetric
      )
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.CreatePredictorRequest.ReadOnly =
    zio.aws.forecast.model.CreatePredictorRequest.wrap(buildAwsValue())
}
object CreatePredictorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreatePredictorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreatePredictorRequest =
      zio.aws.forecast.model.CreatePredictorRequest(
        predictorName,
        algorithmArn.map(value => value),
        forecastHorizon,
        forecastTypes.map(value => value),
        performAutoML.map(value => value),
        autoMLOverrideStrategy.map(value => value),
        performHPO.map(value => value),
        trainingParameters.map(value => value),
        evaluationParameters.map(value => value.asEditable),
        hpoConfig.map(value => value.asEditable),
        inputDataConfig.asEditable,
        featurizationConfig.asEditable,
        encryptionConfig.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        optimizationMetric.map(value => value)
      )
    def predictorName: Name
    def algorithmArn: Optional[Arn]
    def forecastHorizon: Integer
    def forecastTypes: Optional[List[ForecastType]]
    def performAutoML: Optional[Boolean]
    def autoMLOverrideStrategy
        : Optional[zio.aws.forecast.model.AutoMLOverrideStrategy]
    def performHPO: Optional[Boolean]
    def trainingParameters: Optional[Map[ParameterKey, ParameterValue]]
    def evaluationParameters
        : Optional[zio.aws.forecast.model.EvaluationParameters.ReadOnly]
    def hpoConfig: Optional[
      zio.aws.forecast.model.HyperParameterTuningJobConfig.ReadOnly
    ]
    def inputDataConfig: zio.aws.forecast.model.InputDataConfig.ReadOnly
    def featurizationConfig: zio.aws.forecast.model.FeaturizationConfig.ReadOnly
    def encryptionConfig
        : Optional[zio.aws.forecast.model.EncryptionConfig.ReadOnly]
    def tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]]
    def optimizationMetric: Optional[zio.aws.forecast.model.OptimizationMetric]
    def getPredictorName: ZIO[Any, Nothing, Name] = ZIO.succeed(predictorName)
    def getAlgorithmArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("algorithmArn", algorithmArn)
    def getForecastHorizon: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(forecastHorizon)
    def getForecastTypes: ZIO[Any, AwsError, List[ForecastType]] =
      AwsError.unwrapOptionField("forecastTypes", forecastTypes)
    def getPerformAutoML: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("performAutoML", performAutoML)
    def getAutoMLOverrideStrategy
        : ZIO[Any, AwsError, zio.aws.forecast.model.AutoMLOverrideStrategy] =
      AwsError.unwrapOptionField(
        "autoMLOverrideStrategy",
        autoMLOverrideStrategy
      )
    def getPerformHPO: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("performHPO", performHPO)
    def getTrainingParameters
        : ZIO[Any, AwsError, Map[ParameterKey, ParameterValue]] =
      AwsError.unwrapOptionField("trainingParameters", trainingParameters)
    def getEvaluationParameters: ZIO[
      Any,
      AwsError,
      zio.aws.forecast.model.EvaluationParameters.ReadOnly
    ] = AwsError.unwrapOptionField("evaluationParameters", evaluationParameters)
    def getHpoConfig: ZIO[
      Any,
      AwsError,
      zio.aws.forecast.model.HyperParameterTuningJobConfig.ReadOnly
    ] = AwsError.unwrapOptionField("hpoConfig", hpoConfig)
    def getInputDataConfig
        : ZIO[Any, Nothing, zio.aws.forecast.model.InputDataConfig.ReadOnly] =
      ZIO.succeed(inputDataConfig)
    def getFeaturizationConfig: ZIO[
      Any,
      Nothing,
      zio.aws.forecast.model.FeaturizationConfig.ReadOnly
    ] = ZIO.succeed(featurizationConfig)
    def getEncryptionConfig
        : ZIO[Any, AwsError, zio.aws.forecast.model.EncryptionConfig.ReadOnly] =
      AwsError.unwrapOptionField("encryptionConfig", encryptionConfig)
    def getTags: ZIO[Any, AwsError, List[zio.aws.forecast.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getOptimizationMetric
        : ZIO[Any, AwsError, zio.aws.forecast.model.OptimizationMetric] =
      AwsError.unwrapOptionField("optimizationMetric", optimizationMetric)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreatePredictorRequest
  ) extends zio.aws.forecast.model.CreatePredictorRequest.ReadOnly {
    override val predictorName: Name =
      zio.aws.forecast.model.primitives.Name(impl.predictorName())
    override val algorithmArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.algorithmArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val forecastHorizon: Integer = impl.forecastHorizon(): Integer
    override val forecastTypes: Optional[List[ForecastType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forecastTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.primitives.ForecastType(item)
          }.toList
        )
    override val performAutoML: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.performAutoML())
      .map(value => value: Boolean)
    override val autoMLOverrideStrategy
        : Optional[zio.aws.forecast.model.AutoMLOverrideStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMLOverrideStrategy())
        .map(value => zio.aws.forecast.model.AutoMLOverrideStrategy.wrap(value))
    override val performHPO: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.performHPO())
      .map(value => value: Boolean)
    override val trainingParameters
        : Optional[Map[ParameterKey, ParameterValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.trainingParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.forecast.model.primitives.ParameterKey(
              key
            ) -> zio.aws.forecast.model.primitives.ParameterValue(value)
          })
          .toMap
      )
    override val evaluationParameters
        : Optional[zio.aws.forecast.model.EvaluationParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationParameters())
        .map(value => zio.aws.forecast.model.EvaluationParameters.wrap(value))
    override val hpoConfig: Optional[
      zio.aws.forecast.model.HyperParameterTuningJobConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.hpoConfig())
      .map(value =>
        zio.aws.forecast.model.HyperParameterTuningJobConfig.wrap(value)
      )
    override val inputDataConfig
        : zio.aws.forecast.model.InputDataConfig.ReadOnly =
      zio.aws.forecast.model.InputDataConfig.wrap(impl.inputDataConfig())
    override val featurizationConfig
        : zio.aws.forecast.model.FeaturizationConfig.ReadOnly =
      zio.aws.forecast.model.FeaturizationConfig
        .wrap(impl.featurizationConfig())
    override val encryptionConfig
        : Optional[zio.aws.forecast.model.EncryptionConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionConfig())
        .map(value => zio.aws.forecast.model.EncryptionConfig.wrap(value))
    override val tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.Tag.wrap(item)
          }.toList
        )
    override val optimizationMetric
        : Optional[zio.aws.forecast.model.OptimizationMetric] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optimizationMetric())
        .map(value => zio.aws.forecast.model.OptimizationMetric.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreatePredictorRequest
  ): zio.aws.forecast.model.CreatePredictorRequest.ReadOnly = new Wrapper(impl)
}
