package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreatePredictorResponse(
    predictorArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreatePredictorResponse = {
    import CreatePredictorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreatePredictorResponse
      .builder()
      .optionallyWith(
        predictorArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.predictorArn)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.CreatePredictorResponse.ReadOnly =
    zio.aws.forecast.model.CreatePredictorResponse.wrap(buildAwsValue())
}
object CreatePredictorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreatePredictorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreatePredictorResponse =
      zio.aws.forecast.model
        .CreatePredictorResponse(predictorArn.map(value => value))
    def predictorArn: Optional[Arn]
    def getPredictorArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("predictorArn", predictorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreatePredictorResponse
  ) extends zio.aws.forecast.model.CreatePredictorResponse.ReadOnly {
    override val predictorArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.predictorArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreatePredictorResponse
  ): zio.aws.forecast.model.CreatePredictorResponse.ReadOnly = new Wrapper(impl)
}
