package zio.aws.forecast.model
import scala.jdk.CollectionConverters._
sealed trait DayOfWeek {
  def unwrap: software.amazon.awssdk.services.forecast.model.DayOfWeek
}
object DayOfWeek {
  def wrap(
      value: software.amazon.awssdk.services.forecast.model.DayOfWeek
  ): zio.aws.forecast.model.DayOfWeek = value match {
    case software.amazon.awssdk.services.forecast.model.DayOfWeek.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.forecast.model.DayOfWeek.MONDAY =>
      val r = MONDAY
      r
    case software.amazon.awssdk.services.forecast.model.DayOfWeek.TUESDAY =>
      val r = TUESDAY
      r
    case software.amazon.awssdk.services.forecast.model.DayOfWeek.WEDNESDAY =>
      val r = WEDNESDAY
      r
    case software.amazon.awssdk.services.forecast.model.DayOfWeek.THURSDAY =>
      val r = THURSDAY
      r
    case software.amazon.awssdk.services.forecast.model.DayOfWeek.FRIDAY =>
      val r = FRIDAY
      r
    case software.amazon.awssdk.services.forecast.model.DayOfWeek.SATURDAY =>
      val r = SATURDAY
      r
    case software.amazon.awssdk.services.forecast.model.DayOfWeek.SUNDAY =>
      val r = SUNDAY
      r
  }
  case object unknownToSdkVersion extends zio.aws.forecast.model.DayOfWeek {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.DayOfWeek =
      software.amazon.awssdk.services.forecast.model.DayOfWeek.UNKNOWN_TO_SDK_VERSION
  }
  case object MONDAY extends zio.aws.forecast.model.DayOfWeek {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.DayOfWeek =
      software.amazon.awssdk.services.forecast.model.DayOfWeek.MONDAY
  }
  case object TUESDAY extends zio.aws.forecast.model.DayOfWeek {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.DayOfWeek =
      software.amazon.awssdk.services.forecast.model.DayOfWeek.TUESDAY
  }
  case object WEDNESDAY extends zio.aws.forecast.model.DayOfWeek {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.DayOfWeek =
      software.amazon.awssdk.services.forecast.model.DayOfWeek.WEDNESDAY
  }
  case object THURSDAY extends zio.aws.forecast.model.DayOfWeek {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.DayOfWeek =
      software.amazon.awssdk.services.forecast.model.DayOfWeek.THURSDAY
  }
  case object FRIDAY extends zio.aws.forecast.model.DayOfWeek {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.DayOfWeek =
      software.amazon.awssdk.services.forecast.model.DayOfWeek.FRIDAY
  }
  case object SATURDAY extends zio.aws.forecast.model.DayOfWeek {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.DayOfWeek =
      software.amazon.awssdk.services.forecast.model.DayOfWeek.SATURDAY
  }
  case object SUNDAY extends zio.aws.forecast.model.DayOfWeek {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.DayOfWeek =
      software.amazon.awssdk.services.forecast.model.DayOfWeek.SUNDAY
  }
}
