package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDatasetImportJobRequest(datasetImportJobArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DeleteDatasetImportJobRequest = {
    import DeleteDatasetImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DeleteDatasetImportJobRequest
      .builder()
      .datasetImportJobArn(Arn.unwrap(datasetImportJobArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.DeleteDatasetImportJobRequest.ReadOnly =
    zio.aws.forecast.model.DeleteDatasetImportJobRequest.wrap(buildAwsValue())
}
object DeleteDatasetImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DeleteDatasetImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DeleteDatasetImportJobRequest =
      zio.aws.forecast.model.DeleteDatasetImportJobRequest(datasetImportJobArn)
    def datasetImportJobArn: Arn
    def getDatasetImportJobArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(datasetImportJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DeleteDatasetImportJobRequest
  ) extends zio.aws.forecast.model.DeleteDatasetImportJobRequest.ReadOnly {
    override val datasetImportJobArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.datasetImportJobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DeleteDatasetImportJobRequest
  ): zio.aws.forecast.model.DeleteDatasetImportJobRequest.ReadOnly =
    new Wrapper(impl)
}
