package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteMonitorRequest(monitorArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DeleteMonitorRequest = {
    import DeleteMonitorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DeleteMonitorRequest
      .builder()
      .monitorArn(Arn.unwrap(monitorArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DeleteMonitorRequest.ReadOnly =
    zio.aws.forecast.model.DeleteMonitorRequest.wrap(buildAwsValue())
}
object DeleteMonitorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DeleteMonitorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DeleteMonitorRequest =
      zio.aws.forecast.model.DeleteMonitorRequest(monitorArn)
    def monitorArn: Arn
    def getMonitorArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(monitorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DeleteMonitorRequest
  ) extends zio.aws.forecast.model.DeleteMonitorRequest.ReadOnly {
    override val monitorArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.monitorArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DeleteMonitorRequest
  ): zio.aws.forecast.model.DeleteMonitorRequest.ReadOnly = new Wrapper(impl)
}
