package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeExplainabilityExportRequest(
    explainabilityExportArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribeExplainabilityExportRequest = {
    import DescribeExplainabilityExportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribeExplainabilityExportRequest
      .builder()
      .explainabilityExportArn(
        Arn.unwrap(explainabilityExportArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.DescribeExplainabilityExportRequest.ReadOnly =
    zio.aws.forecast.model.DescribeExplainabilityExportRequest
      .wrap(buildAwsValue())
}
object DescribeExplainabilityExportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribeExplainabilityExportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DescribeExplainabilityExportRequest =
      zio.aws.forecast.model
        .DescribeExplainabilityExportRequest(explainabilityExportArn)
    def explainabilityExportArn: Arn
    def getExplainabilityExportArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(explainabilityExportArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribeExplainabilityExportRequest
  ) extends zio.aws.forecast.model.DescribeExplainabilityExportRequest.ReadOnly {
    override val explainabilityExportArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.explainabilityExportArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribeExplainabilityExportRequest
  ): zio.aws.forecast.model.DescribeExplainabilityExportRequest.ReadOnly =
    new Wrapper(impl)
}
