package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeExplainabilityRequest(explainabilityArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribeExplainabilityRequest = {
    import DescribeExplainabilityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribeExplainabilityRequest
      .builder()
      .explainabilityArn(Arn.unwrap(explainabilityArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.DescribeExplainabilityRequest.ReadOnly =
    zio.aws.forecast.model.DescribeExplainabilityRequest.wrap(buildAwsValue())
}
object DescribeExplainabilityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribeExplainabilityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DescribeExplainabilityRequest =
      zio.aws.forecast.model.DescribeExplainabilityRequest(explainabilityArn)
    def explainabilityArn: Arn
    def getExplainabilityArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(explainabilityArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribeExplainabilityRequest
  ) extends zio.aws.forecast.model.DescribeExplainabilityRequest.ReadOnly {
    override val explainabilityArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.explainabilityArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribeExplainabilityRequest
  ): zio.aws.forecast.model.DescribeExplainabilityRequest.ReadOnly =
    new Wrapper(impl)
}
