package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{
  Status,
  Message,
  Timestamp,
  Arn,
  Name,
  EvaluationState
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeMonitorResponse(
    monitorName: Optional[Name] = Optional.Absent,
    monitorArn: Optional[Arn] = Optional.Absent,
    resourceArn: Optional[Arn] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    lastEvaluationTime: Optional[Timestamp] = Optional.Absent,
    lastEvaluationState: Optional[EvaluationState] = Optional.Absent,
    baseline: Optional[zio.aws.forecast.model.Baseline] = Optional.Absent,
    message: Optional[Message] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent,
    estimatedEvaluationTimeRemainingInMinutes: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribeMonitorResponse = {
    import DescribeMonitorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribeMonitorResponse
      .builder()
      .optionallyWith(
        monitorName.map(value => Name.unwrap(value): java.lang.String)
      )(_.monitorName)
      .optionallyWith(
        monitorArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.monitorArn)
      .optionallyWith(
        resourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        lastEvaluationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastEvaluationTime)
      .optionallyWith(
        lastEvaluationState.map(value =>
          EvaluationState.unwrap(value): java.lang.String
        )
      )(_.lastEvaluationState)
      .optionallyWith(baseline.map(value => value.buildAwsValue()))(_.baseline)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .optionallyWith(
        estimatedEvaluationTimeRemainingInMinutes.map(value =>
          value: java.lang.Long
        )
      )(_.estimatedEvaluationTimeRemainingInMinutes)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DescribeMonitorResponse.ReadOnly =
    zio.aws.forecast.model.DescribeMonitorResponse.wrap(buildAwsValue())
}
object DescribeMonitorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribeMonitorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DescribeMonitorResponse =
      zio.aws.forecast.model.DescribeMonitorResponse(
        monitorName.map(value => value),
        monitorArn.map(value => value),
        resourceArn.map(value => value),
        status.map(value => value),
        lastEvaluationTime.map(value => value),
        lastEvaluationState.map(value => value),
        baseline.map(value => value.asEditable),
        message.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value),
        estimatedEvaluationTimeRemainingInMinutes.map(value => value)
      )
    def monitorName: Optional[Name]
    def monitorArn: Optional[Arn]
    def resourceArn: Optional[Arn]
    def status: Optional[Status]
    def lastEvaluationTime: Optional[Timestamp]
    def lastEvaluationState: Optional[EvaluationState]
    def baseline: Optional[zio.aws.forecast.model.Baseline.ReadOnly]
    def message: Optional[Message]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def estimatedEvaluationTimeRemainingInMinutes: Optional[Long]
    def getMonitorName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("monitorName", monitorName)
    def getMonitorArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("monitorArn", monitorArn)
    def getResourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getLastEvaluationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastEvaluationTime", lastEvaluationTime)
    def getLastEvaluationState: ZIO[Any, AwsError, EvaluationState] =
      AwsError.unwrapOptionField("lastEvaluationState", lastEvaluationState)
    def getBaseline
        : ZIO[Any, AwsError, zio.aws.forecast.model.Baseline.ReadOnly] =
      AwsError.unwrapOptionField("baseline", baseline)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
    def getEstimatedEvaluationTimeRemainingInMinutes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "estimatedEvaluationTimeRemainingInMinutes",
        estimatedEvaluationTimeRemainingInMinutes
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribeMonitorResponse
  ) extends zio.aws.forecast.model.DescribeMonitorResponse.ReadOnly {
    override val monitorName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.monitorName())
      .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val monitorArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.monitorArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val resourceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.forecast.model.primitives.Status(value))
    override val lastEvaluationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastEvaluationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastEvaluationState: Optional[EvaluationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastEvaluationState())
        .map(value => zio.aws.forecast.model.primitives.EvaluationState(value))
    override val baseline: Optional[zio.aws.forecast.model.Baseline.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.baseline())
        .map(value => zio.aws.forecast.model.Baseline.wrap(value))
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.forecast.model.primitives.Message(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val estimatedEvaluationTimeRemainingInMinutes: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.estimatedEvaluationTimeRemainingInMinutes())
        .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribeMonitorResponse
  ): zio.aws.forecast.model.DescribeMonitorResponse.ReadOnly = new Wrapper(impl)
}
