package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{Status, Message, Timestamp, Arn, Name}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ExplainabilitySummary(
    explainabilityArn: Optional[Arn] = Optional.Absent,
    explainabilityName: Optional[Name] = Optional.Absent,
    resourceArn: Optional[Arn] = Optional.Absent,
    explainabilityConfig: Optional[
      zio.aws.forecast.model.ExplainabilityConfig
    ] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    message: Optional[Message] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ExplainabilitySummary = {
    import ExplainabilitySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ExplainabilitySummary
      .builder()
      .optionallyWith(
        explainabilityArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.explainabilityArn)
      .optionallyWith(
        explainabilityName.map(value => Name.unwrap(value): java.lang.String)
      )(_.explainabilityName)
      .optionallyWith(
        resourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(explainabilityConfig.map(value => value.buildAwsValue()))(
        _.explainabilityConfig
      )
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.ExplainabilitySummary.ReadOnly =
    zio.aws.forecast.model.ExplainabilitySummary.wrap(buildAwsValue())
}
object ExplainabilitySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ExplainabilitySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.ExplainabilitySummary =
      zio.aws.forecast.model.ExplainabilitySummary(
        explainabilityArn.map(value => value),
        explainabilityName.map(value => value),
        resourceArn.map(value => value),
        explainabilityConfig.map(value => value.asEditable),
        status.map(value => value),
        message.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value)
      )
    def explainabilityArn: Optional[Arn]
    def explainabilityName: Optional[Name]
    def resourceArn: Optional[Arn]
    def explainabilityConfig
        : Optional[zio.aws.forecast.model.ExplainabilityConfig.ReadOnly]
    def status: Optional[Status]
    def message: Optional[Message]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def getExplainabilityArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("explainabilityArn", explainabilityArn)
    def getExplainabilityName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("explainabilityName", explainabilityName)
    def getResourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getExplainabilityConfig: ZIO[
      Any,
      AwsError,
      zio.aws.forecast.model.ExplainabilityConfig.ReadOnly
    ] = AwsError.unwrapOptionField("explainabilityConfig", explainabilityConfig)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ExplainabilitySummary
  ) extends zio.aws.forecast.model.ExplainabilitySummary.ReadOnly {
    override val explainabilityArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.explainabilityArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val explainabilityName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.explainabilityName())
      .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val resourceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val explainabilityConfig
        : Optional[zio.aws.forecast.model.ExplainabilityConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.explainabilityConfig())
        .map(value => zio.aws.forecast.model.ExplainabilityConfig.wrap(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.forecast.model.primitives.Status(value))
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.forecast.model.primitives.Message(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ExplainabilitySummary
  ): zio.aws.forecast.model.ExplainabilitySummary.ReadOnly = new Wrapper(impl)
}
