package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{Name, Frequency}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FeaturizationConfig(
    forecastFrequency: Frequency,
    forecastDimensions: Optional[Iterable[Name]] = Optional.Absent,
    featurizations: Optional[Iterable[zio.aws.forecast.model.Featurization]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.FeaturizationConfig = {
    import FeaturizationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.FeaturizationConfig
      .builder()
      .forecastFrequency(Frequency.unwrap(forecastFrequency): java.lang.String)
      .optionallyWith(
        forecastDimensions.map(value =>
          value.map { item =>
            Name.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.forecastDimensions)
      .optionallyWith(
        featurizations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.featurizations)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.FeaturizationConfig.ReadOnly =
    zio.aws.forecast.model.FeaturizationConfig.wrap(buildAwsValue())
}
object FeaturizationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.FeaturizationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.FeaturizationConfig =
      zio.aws.forecast.model.FeaturizationConfig(
        forecastFrequency,
        forecastDimensions.map(value => value),
        featurizations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def forecastFrequency: Frequency
    def forecastDimensions: Optional[List[Name]]
    def featurizations
        : Optional[List[zio.aws.forecast.model.Featurization.ReadOnly]]
    def getForecastFrequency: ZIO[Any, Nothing, Frequency] =
      ZIO.succeed(forecastFrequency)
    def getForecastDimensions: ZIO[Any, AwsError, List[Name]] =
      AwsError.unwrapOptionField("forecastDimensions", forecastDimensions)
    def getFeaturizations: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.Featurization.ReadOnly
    ]] = AwsError.unwrapOptionField("featurizations", featurizations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.FeaturizationConfig
  ) extends zio.aws.forecast.model.FeaturizationConfig.ReadOnly {
    override val forecastFrequency: Frequency =
      zio.aws.forecast.model.primitives.Frequency(impl.forecastFrequency())
    override val forecastDimensions: Optional[List[Name]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forecastDimensions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.primitives.Name(item)
          }.toList
        )
    override val featurizations
        : Optional[List[zio.aws.forecast.model.Featurization.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featurizations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.Featurization.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.FeaturizationConfig
  ): zio.aws.forecast.model.FeaturizationConfig.ReadOnly = new Wrapper(impl)
}
