package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{
  Status,
  ErrorMessage,
  Timestamp,
  Arn,
  Name
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ForecastSummary(
    forecastArn: Optional[Arn] = Optional.Absent,
    forecastName: Optional[Name] = Optional.Absent,
    predictorArn: Optional[String] = Optional.Absent,
    createdUsingAutoPredictor: Optional[Boolean] = Optional.Absent,
    datasetGroupArn: Optional[String] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    message: Optional[ErrorMessage] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ForecastSummary = {
    import ForecastSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ForecastSummary
      .builder()
      .optionallyWith(
        forecastArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.forecastArn)
      .optionallyWith(
        forecastName.map(value => Name.unwrap(value): java.lang.String)
      )(_.forecastName)
      .optionallyWith(predictorArn.map(value => value: java.lang.String))(
        _.predictorArn
      )
      .optionallyWith(
        createdUsingAutoPredictor.map(value => value: java.lang.Boolean)
      )(_.createdUsingAutoPredictor)
      .optionallyWith(datasetGroupArn.map(value => value: java.lang.String))(
        _.datasetGroupArn
      )
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.ForecastSummary.ReadOnly =
    zio.aws.forecast.model.ForecastSummary.wrap(buildAwsValue())
}
object ForecastSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ForecastSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.ForecastSummary =
      zio.aws.forecast.model.ForecastSummary(
        forecastArn.map(value => value),
        forecastName.map(value => value),
        predictorArn.map(value => value),
        createdUsingAutoPredictor.map(value => value),
        datasetGroupArn.map(value => value),
        status.map(value => value),
        message.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value)
      )
    def forecastArn: Optional[Arn]
    def forecastName: Optional[Name]
    def predictorArn: Optional[String]
    def createdUsingAutoPredictor: Optional[Boolean]
    def datasetGroupArn: Optional[String]
    def status: Optional[Status]
    def message: Optional[ErrorMessage]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def getForecastArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("forecastArn", forecastArn)
    def getForecastName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("forecastName", forecastName)
    def getPredictorArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("predictorArn", predictorArn)
    def getCreatedUsingAutoPredictor: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("createdUsingAutoPredictor", createdUsingAutoPredictor)
    def getDatasetGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("datasetGroupArn", datasetGroupArn)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ForecastSummary
  ) extends zio.aws.forecast.model.ForecastSummary.ReadOnly {
    override val forecastArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.forecastArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val forecastName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.forecastName())
      .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val predictorArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.predictorArn())
      .map(value => value: String)
    override val createdUsingAutoPredictor: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdUsingAutoPredictor())
        .map(value => value: Boolean)
    override val datasetGroupArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetGroupArn())
      .map(value => value: String)
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.forecast.model.primitives.Status(value))
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.forecast.model.primitives.ErrorMessage(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ForecastSummary
  ): zio.aws.forecast.model.ForecastSummary.ReadOnly = new Wrapper(impl)
}
