package zio.aws.forecast.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{MaxResults, NextToken}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDatasetImportJobsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.forecast.model.Filter]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ListDatasetImportJobsRequest = {
    import ListDatasetImportJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ListDatasetImportJobsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.ListDatasetImportJobsRequest.ReadOnly =
    zio.aws.forecast.model.ListDatasetImportJobsRequest.wrap(buildAwsValue())
}
object ListDatasetImportJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ListDatasetImportJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.ListDatasetImportJobsRequest =
      zio.aws.forecast.model.ListDatasetImportJobsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def filters: Optional[List[zio.aws.forecast.model.Filter.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.forecast.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ListDatasetImportJobsRequest
  ) extends zio.aws.forecast.model.ListDatasetImportJobsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.forecast.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.forecast.model.primitives.MaxResults(value))
    override val filters
        : Optional[List[zio.aws.forecast.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ListDatasetImportJobsRequest
  ): zio.aws.forecast.model.ListDatasetImportJobsRequest.ReadOnly = new Wrapper(
    impl
  )
}
