package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDatasetsResponse(
    datasets: Optional[Iterable[zio.aws.forecast.model.DatasetSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ListDatasetsResponse = {
    import ListDatasetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ListDatasetsResponse
      .builder()
      .optionallyWith(
        datasets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.datasets)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.ListDatasetsResponse.ReadOnly =
    zio.aws.forecast.model.ListDatasetsResponse.wrap(buildAwsValue())
}
object ListDatasetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ListDatasetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.ListDatasetsResponse =
      zio.aws.forecast.model.ListDatasetsResponse(
        datasets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def datasets: Optional[List[zio.aws.forecast.model.DatasetSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getDatasets: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.DatasetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("datasets", datasets)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ListDatasetsResponse
  ) extends zio.aws.forecast.model.ListDatasetsResponse.ReadOnly {
    override val datasets
        : Optional[List[zio.aws.forecast.model.DatasetSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.DatasetSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.forecast.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ListDatasetsResponse
  ): zio.aws.forecast.model.ListDatasetsResponse.ReadOnly = new Wrapper(impl)
}
