package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListExplainabilitiesResponse(
    explainabilities: Optional[
      Iterable[zio.aws.forecast.model.ExplainabilitySummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ListExplainabilitiesResponse = {
    import ListExplainabilitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ListExplainabilitiesResponse
      .builder()
      .optionallyWith(
        explainabilities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.explainabilities)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.ListExplainabilitiesResponse.ReadOnly =
    zio.aws.forecast.model.ListExplainabilitiesResponse.wrap(buildAwsValue())
}
object ListExplainabilitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ListExplainabilitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.ListExplainabilitiesResponse =
      zio.aws.forecast.model.ListExplainabilitiesResponse(
        explainabilities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def explainabilities
        : Optional[List[zio.aws.forecast.model.ExplainabilitySummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getExplainabilities: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.ExplainabilitySummary.ReadOnly
    ]] = AwsError.unwrapOptionField("explainabilities", explainabilities)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ListExplainabilitiesResponse
  ) extends zio.aws.forecast.model.ListExplainabilitiesResponse.ReadOnly {
    override val explainabilities: Optional[
      List[zio.aws.forecast.model.ExplainabilitySummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.explainabilities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.forecast.model.ExplainabilitySummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.forecast.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ListExplainabilitiesResponse
  ): zio.aws.forecast.model.ListExplainabilitiesResponse.ReadOnly = new Wrapper(
    impl
  )
}
