package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MonitorDataSource(
    datasetImportJobArn: Optional[Arn] = Optional.Absent,
    forecastArn: Optional[Arn] = Optional.Absent,
    predictorArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.MonitorDataSource = {
    import MonitorDataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.MonitorDataSource
      .builder()
      .optionallyWith(
        datasetImportJobArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetImportJobArn)
      .optionallyWith(
        forecastArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.forecastArn)
      .optionallyWith(
        predictorArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.predictorArn)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.MonitorDataSource.ReadOnly =
    zio.aws.forecast.model.MonitorDataSource.wrap(buildAwsValue())
}
object MonitorDataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.MonitorDataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.MonitorDataSource =
      zio.aws.forecast.model.MonitorDataSource(
        datasetImportJobArn.map(value => value),
        forecastArn.map(value => value),
        predictorArn.map(value => value)
      )
    def datasetImportJobArn: Optional[Arn]
    def forecastArn: Optional[Arn]
    def predictorArn: Optional[Arn]
    def getDatasetImportJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetImportJobArn", datasetImportJobArn)
    def getForecastArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("forecastArn", forecastArn)
    def getPredictorArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("predictorArn", predictorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.MonitorDataSource
  ) extends zio.aws.forecast.model.MonitorDataSource.ReadOnly {
    override val datasetImportJobArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetImportJobArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val forecastArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.forecastArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val predictorArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.predictorArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.MonitorDataSource
  ): zio.aws.forecast.model.MonitorDataSource.ReadOnly = new Wrapper(impl)
}
