package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{Timestamp, Status, Name, Arn}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class MonitorSummary(
    monitorArn: Optional[Arn] = Optional.Absent,
    monitorName: Optional[Name] = Optional.Absent,
    resourceArn: Optional[Arn] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.MonitorSummary = {
    import MonitorSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.MonitorSummary
      .builder()
      .optionallyWith(
        monitorArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.monitorArn)
      .optionallyWith(
        monitorName.map(value => Name.unwrap(value): java.lang.String)
      )(_.monitorName)
      .optionallyWith(
        resourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.MonitorSummary.ReadOnly =
    zio.aws.forecast.model.MonitorSummary.wrap(buildAwsValue())
}
object MonitorSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.MonitorSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.MonitorSummary =
      zio.aws.forecast.model.MonitorSummary(
        monitorArn.map(value => value),
        monitorName.map(value => value),
        resourceArn.map(value => value),
        status.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value)
      )
    def monitorArn: Optional[Arn]
    def monitorName: Optional[Name]
    def resourceArn: Optional[Arn]
    def status: Optional[Status]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def getMonitorArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("monitorArn", monitorArn)
    def getMonitorName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("monitorName", monitorName)
    def getResourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.MonitorSummary
  ) extends zio.aws.forecast.model.MonitorSummary.ReadOnly {
    override val monitorArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.monitorArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val monitorName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.monitorName())
      .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val resourceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.forecast.model.primitives.Status(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.MonitorSummary
  ): zio.aws.forecast.model.MonitorSummary.ReadOnly = new Wrapper(impl)
}
