package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{
  Status,
  ErrorMessage,
  Timestamp,
  Arn,
  Name
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class PredictorBacktestExportJobSummary(
    predictorBacktestExportJobArn: Optional[Arn] = Optional.Absent,
    predictorBacktestExportJobName: Optional[Name] = Optional.Absent,
    destination: Optional[zio.aws.forecast.model.DataDestination] =
      Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    message: Optional[ErrorMessage] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.PredictorBacktestExportJobSummary = {
    import PredictorBacktestExportJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.PredictorBacktestExportJobSummary
      .builder()
      .optionallyWith(
        predictorBacktestExportJobArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.predictorBacktestExportJobArn)
      .optionallyWith(
        predictorBacktestExportJobName.map(value =>
          Name.unwrap(value): java.lang.String
        )
      )(_.predictorBacktestExportJobName)
      .optionallyWith(destination.map(value => value.buildAwsValue()))(
        _.destination
      )
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.PredictorBacktestExportJobSummary.ReadOnly =
    zio.aws.forecast.model.PredictorBacktestExportJobSummary
      .wrap(buildAwsValue())
}
object PredictorBacktestExportJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.PredictorBacktestExportJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.PredictorBacktestExportJobSummary =
      zio.aws.forecast.model.PredictorBacktestExportJobSummary(
        predictorBacktestExportJobArn.map(value => value),
        predictorBacktestExportJobName.map(value => value),
        destination.map(value => value.asEditable),
        status.map(value => value),
        message.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value)
      )
    def predictorBacktestExportJobArn: Optional[Arn]
    def predictorBacktestExportJobName: Optional[Name]
    def destination: Optional[zio.aws.forecast.model.DataDestination.ReadOnly]
    def status: Optional[Status]
    def message: Optional[ErrorMessage]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def getPredictorBacktestExportJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField(
        "predictorBacktestExportJobArn",
        predictorBacktestExportJobArn
      )
    def getPredictorBacktestExportJobName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField(
        "predictorBacktestExportJobName",
        predictorBacktestExportJobName
      )
    def getDestination
        : ZIO[Any, AwsError, zio.aws.forecast.model.DataDestination.ReadOnly] =
      AwsError.unwrapOptionField("destination", destination)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.PredictorBacktestExportJobSummary
  ) extends zio.aws.forecast.model.PredictorBacktestExportJobSummary.ReadOnly {
    override val predictorBacktestExportJobArn: Optional[Arn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.predictorBacktestExportJobArn())
        .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val predictorBacktestExportJobName: Optional[Name] =
      zio.aws.core.internal
        .optionalFromNullable(impl.predictorBacktestExportJobName())
        .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val destination
        : Optional[zio.aws.forecast.model.DataDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destination())
        .map(value => zio.aws.forecast.model.DataDestination.wrap(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.forecast.model.primitives.Status(value))
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.forecast.model.primitives.ErrorMessage(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.PredictorBacktestExportJobSummary
  ): zio.aws.forecast.model.PredictorBacktestExportJobSummary.ReadOnly =
    new Wrapper(impl)
}
