package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{Timestamp, Detail}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class PredictorEvent(
    detail: Optional[Detail] = Optional.Absent,
    datetime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.PredictorEvent = {
    import PredictorEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.PredictorEvent
      .builder()
      .optionallyWith(
        detail.map(value => Detail.unwrap(value): java.lang.String)
      )(_.detail)
      .optionallyWith(datetime.map(value => Timestamp.unwrap(value): Instant))(
        _.datetime
      )
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.PredictorEvent.ReadOnly =
    zio.aws.forecast.model.PredictorEvent.wrap(buildAwsValue())
}
object PredictorEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.PredictorEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.PredictorEvent =
      zio.aws.forecast.model.PredictorEvent(
        detail.map(value => value),
        datetime.map(value => value)
      )
    def detail: Optional[Detail]
    def datetime: Optional[Timestamp]
    def getDetail: ZIO[Any, AwsError, Detail] =
      AwsError.unwrapOptionField("detail", detail)
    def getDatetime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("datetime", datetime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.PredictorEvent
  ) extends zio.aws.forecast.model.PredictorEvent.ReadOnly {
    override val detail: Optional[Detail] = zio.aws.core.internal
      .optionalFromNullable(impl.detail())
      .map(value => zio.aws.forecast.model.primitives.Detail(value))
    override val datetime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.datetime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.PredictorEvent
  ): zio.aws.forecast.model.PredictorEvent.ReadOnly = new Wrapper(impl)
}
