package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{KMSKeyArn, Arn, S3Path}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3Config(
    path: S3Path,
    roleArn: Arn,
    kmsKeyArn: Optional[KMSKeyArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.S3Config = {
    import S3Config.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.S3Config
      .builder()
      .path(S3Path.unwrap(path): java.lang.String)
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        kmsKeyArn.map(value => KMSKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.S3Config.ReadOnly =
    zio.aws.forecast.model.S3Config.wrap(buildAwsValue())
}
object S3Config {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.forecast.model.S3Config] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.S3Config = zio.aws.forecast.model
      .S3Config(path, roleArn, kmsKeyArn.map(value => value))
    def path: S3Path
    def roleArn: Arn
    def kmsKeyArn: Optional[KMSKeyArn]
    def getPath: ZIO[Any, Nothing, S3Path] = ZIO.succeed(path)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getKmsKeyArn: ZIO[Any, AwsError, KMSKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.S3Config
  ) extends zio.aws.forecast.model.S3Config.ReadOnly {
    override val path: S3Path =
      zio.aws.forecast.model.primitives.S3Path(impl.path())
    override val roleArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.roleArn())
    override val kmsKeyArn: Optional[KMSKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.forecast.model.primitives.KMSKeyArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.S3Config
  ): zio.aws.forecast.model.S3Config.ReadOnly = new Wrapper(impl)
}
