package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Statistics(
    count: Optional[Integer] = Optional.Absent,
    countDistinct: Optional[Integer] = Optional.Absent,
    countNull: Optional[Integer] = Optional.Absent,
    countNan: Optional[Integer] = Optional.Absent,
    min: Optional[String] = Optional.Absent,
    max: Optional[String] = Optional.Absent,
    avg: Optional[Double] = Optional.Absent,
    stddev: Optional[Double] = Optional.Absent,
    countLong: Optional[Long] = Optional.Absent,
    countDistinctLong: Optional[Long] = Optional.Absent,
    countNullLong: Optional[Long] = Optional.Absent,
    countNanLong: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.Statistics = {
    import Statistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.Statistics
      .builder()
      .optionallyWith(count.map(value => value: java.lang.Integer))(_.count)
      .optionallyWith(countDistinct.map(value => value: java.lang.Integer))(
        _.countDistinct
      )
      .optionallyWith(countNull.map(value => value: java.lang.Integer))(
        _.countNull
      )
      .optionallyWith(countNan.map(value => value: java.lang.Integer))(
        _.countNan
      )
      .optionallyWith(min.map(value => value: java.lang.String))(_.min)
      .optionallyWith(max.map(value => value: java.lang.String))(_.max)
      .optionallyWith(avg.map(value => value: java.lang.Double))(_.avg)
      .optionallyWith(stddev.map(value => value: java.lang.Double))(_.stddev)
      .optionallyWith(countLong.map(value => value: java.lang.Long))(
        _.countLong
      )
      .optionallyWith(countDistinctLong.map(value => value: java.lang.Long))(
        _.countDistinctLong
      )
      .optionallyWith(countNullLong.map(value => value: java.lang.Long))(
        _.countNullLong
      )
      .optionallyWith(countNanLong.map(value => value: java.lang.Long))(
        _.countNanLong
      )
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.Statistics.ReadOnly =
    zio.aws.forecast.model.Statistics.wrap(buildAwsValue())
}
object Statistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.Statistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.Statistics =
      zio.aws.forecast.model.Statistics(
        count.map(value => value),
        countDistinct.map(value => value),
        countNull.map(value => value),
        countNan.map(value => value),
        min.map(value => value),
        max.map(value => value),
        avg.map(value => value),
        stddev.map(value => value),
        countLong.map(value => value),
        countDistinctLong.map(value => value),
        countNullLong.map(value => value),
        countNanLong.map(value => value)
      )
    def count: Optional[Integer]
    def countDistinct: Optional[Integer]
    def countNull: Optional[Integer]
    def countNan: Optional[Integer]
    def min: Optional[String]
    def max: Optional[String]
    def avg: Optional[Double]
    def stddev: Optional[Double]
    def countLong: Optional[Long]
    def countDistinctLong: Optional[Long]
    def countNullLong: Optional[Long]
    def countNanLong: Optional[Long]
    def getCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("count", count)
    def getCountDistinct: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("countDistinct", countDistinct)
    def getCountNull: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("countNull", countNull)
    def getCountNan: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("countNan", countNan)
    def getMin: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("min", min)
    def getMax: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("max", max)
    def getAvg: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("avg", avg)
    def getStddev: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("stddev", stddev)
    def getCountLong: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("countLong", countLong)
    def getCountDistinctLong: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("countDistinctLong", countDistinctLong)
    def getCountNullLong: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("countNullLong", countNullLong)
    def getCountNanLong: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("countNanLong", countNanLong)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.Statistics
  ) extends zio.aws.forecast.model.Statistics.ReadOnly {
    override val count: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => value: Integer)
    override val countDistinct: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.countDistinct())
      .map(value => value: Integer)
    override val countNull: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.countNull())
      .map(value => value: Integer)
    override val countNan: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.countNan())
      .map(value => value: Integer)
    override val min: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.min())
      .map(value => value: String)
    override val max: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.max())
      .map(value => value: String)
    override val avg: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.avg())
      .map(value => value: Double)
    override val stddev: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.stddev())
      .map(value => value: Double)
    override val countLong: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.countLong())
      .map(value => value: Long)
    override val countDistinctLong: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.countDistinctLong())
      .map(value => value: Long)
    override val countNullLong: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.countNullLong())
      .map(value => value: Long)
    override val countNanLong: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.countNanLong())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.Statistics
  ): zio.aws.forecast.model.Statistics.ReadOnly = new Wrapper(impl)
}
