package zio.aws.forecast
import zio.prelude.Subtype
import zio.aws.forecast.model.primitives.{
  ParameterKey,
  ParameterValue,
  ForecastType,
  Arn,
  Value,
  Name,
  TagKey
}
import java.time.Instant
import zio.aws.forecast.model.primitives.Detail.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object Arn extends Subtype[String]
    type Arn = zio.aws.forecast.model.primitives.Arn.Type
    object DayOfMonth extends Subtype[Int]
    type DayOfMonth = zio.aws.forecast.model.primitives.DayOfMonth.Type
    object Detail extends Subtype[String]
    type Detail = zio.aws.forecast.model.primitives.Detail.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.forecast.model.primitives.ErrorMessage.Type
    object EvaluationState extends Subtype[String]
    type EvaluationState =
      zio.aws.forecast.model.primitives.EvaluationState.Type
    object ForecastType extends Subtype[String]
    type ForecastType = zio.aws.forecast.model.primitives.ForecastType.Type
    object Format extends Subtype[String]
    type Format = zio.aws.forecast.model.primitives.Format.Type
    object Frequency extends Subtype[String]
    type Frequency = zio.aws.forecast.model.primitives.Frequency.Type
    object GeolocationFormat extends Subtype[String]
    type GeolocationFormat =
      zio.aws.forecast.model.primitives.GeolocationFormat.Type
    object Hour extends Subtype[Int]
    type Hour = zio.aws.forecast.model.primitives.Hour.Type
    type Integer = Int
    object KMSKeyArn extends Subtype[String]
    type KMSKeyArn = zio.aws.forecast.model.primitives.KMSKeyArn.Type
    object LocalDateTime extends Subtype[String]
    type LocalDateTime = zio.aws.forecast.model.primitives.LocalDateTime.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.forecast.model.primitives.MaxResults.Type
    object Message extends Subtype[String]
    type Message = zio.aws.forecast.model.primitives.Message.Type
    object MetricName extends Subtype[String]
    type MetricName = zio.aws.forecast.model.primitives.MetricName.Type
    object Name extends Subtype[String]
    type Name = zio.aws.forecast.model.primitives.Name.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.forecast.model.primitives.NextToken.Type
    object ParameterKey extends Subtype[String]
    type ParameterKey = zio.aws.forecast.model.primitives.ParameterKey.Type
    object ParameterValue extends Subtype[String]
    type ParameterValue = zio.aws.forecast.model.primitives.ParameterValue.Type
    object S3Path extends Subtype[String]
    type S3Path = zio.aws.forecast.model.primitives.S3Path.Type
    object Status extends Subtype[String]
    type Status = zio.aws.forecast.model.primitives.Status.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.forecast.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.forecast.model.primitives.TagValue.Type
    object TimeZone extends Subtype[String]
    type TimeZone = zio.aws.forecast.model.primitives.TimeZone.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.forecast.model.primitives.Timestamp.Type
    object TimestampFormat extends Subtype[String]
    type TimestampFormat =
      zio.aws.forecast.model.primitives.TimestampFormat.Type
    object UseGeolocationForTimeZone extends Subtype[Boolean]
    type UseGeolocationForTimeZone =
      zio.aws.forecast.model.primitives.UseGeolocationForTimeZone.Type
    object Value extends Subtype[String]
    type Value = zio.aws.forecast.model.primitives.Value.Type
  }
  type AdditionalDatasets = List[zio.aws.forecast.model.AdditionalDataset]
  type ArnList = List[Arn]
  type AttributeConfigs = List[zio.aws.forecast.model.AttributeConfig]
  type BaselineMetrics = List[zio.aws.forecast.model.BaselineMetric]
  type CategoricalParameterRanges =
    List[zio.aws.forecast.model.CategoricalParameterRange]
  type Configuration = Map[Name, Iterable[Value]]
  type ContinuousParameterRanges =
    List[zio.aws.forecast.model.ContinuousParameterRange]
  type DatasetGroups = List[zio.aws.forecast.model.DatasetGroupSummary]
  type DatasetImportJobs = List[zio.aws.forecast.model.DatasetImportJobSummary]
  type Datasets = List[zio.aws.forecast.model.DatasetSummary]
  type ErrorMetrics = List[zio.aws.forecast.model.ErrorMetric]
  type Explainabilities = List[zio.aws.forecast.model.ExplainabilitySummary]
  type ExplainabilityExports =
    List[zio.aws.forecast.model.ExplainabilityExportSummary]
  type FeaturizationMethodParameters = Map[ParameterKey, ParameterValue]
  type FeaturizationPipeline = List[zio.aws.forecast.model.FeaturizationMethod]
  type Featurizations = List[zio.aws.forecast.model.Featurization]
  type FieldStatistics = Map[String, zio.aws.forecast.model.Statistics]
  type Filters = List[zio.aws.forecast.model.Filter]
  type ForecastDimensions = List[Name]
  type ForecastExportJobs =
    List[zio.aws.forecast.model.ForecastExportJobSummary]
  type ForecastTypes = List[ForecastType]
  type Forecasts = List[zio.aws.forecast.model.ForecastSummary]
  type IntegerParameterRanges =
    List[zio.aws.forecast.model.IntegerParameterRange]
  type MetricResults = List[zio.aws.forecast.model.MetricResult]
  type Monitors = List[zio.aws.forecast.model.MonitorSummary]
  type PredictorBacktestExportJobs =
    List[zio.aws.forecast.model.PredictorBacktestExportJobSummary]
  type PredictorEvaluationResults =
    List[zio.aws.forecast.model.EvaluationResult]
  type PredictorExecutions = List[zio.aws.forecast.model.PredictorExecution]
  type PredictorMonitorEvaluations =
    List[zio.aws.forecast.model.PredictorMonitorEvaluation]
  type Predictors = List[zio.aws.forecast.model.PredictorSummary]
  type SchemaAttributes = List[zio.aws.forecast.model.SchemaAttribute]
  type SupplementaryFeatures = List[zio.aws.forecast.model.SupplementaryFeature]
  type TagKeys = List[TagKey]
  type Tags = List[zio.aws.forecast.model.Tag]
  type TestWindowDetails = List[zio.aws.forecast.model.TestWindowSummary]
  type TestWindows = List[zio.aws.forecast.model.WindowSummary]
  type TrainingParameters = Map[ParameterKey, ParameterValue]
  type Transformations = Map[Name, Value]
  type Values = List[Value]
  type WeightedQuantileLosses =
    List[zio.aws.forecast.model.WeightedQuantileLoss]
}
