package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Name
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Action(
    attributeName: Name,
    operation: zio.aws.forecast.model.Operation,
    value: Double
) {
  def buildAwsValue(): software.amazon.awssdk.services.forecast.model.Action = {
    import Action.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.Action
      .builder()
      .attributeName(Name.unwrap(attributeName): java.lang.String)
      .operation(operation.unwrap)
      .value(value: java.lang.Double)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.Action.ReadOnly =
    zio.aws.forecast.model.Action.wrap(buildAwsValue())
}
object Action {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.forecast.model.Action] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.Action =
      zio.aws.forecast.model.Action(attributeName, operation, value)
    def attributeName: Name
    def operation: zio.aws.forecast.model.Operation
    def value: Double
    def getAttributeName: ZIO[Any, Nothing, Name] = ZIO.succeed(attributeName)
    def getOperation: ZIO[Any, Nothing, zio.aws.forecast.model.Operation] =
      ZIO.succeed(operation)
    def getValue: ZIO[Any, Nothing, Double] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.Action
  ) extends zio.aws.forecast.model.Action.ReadOnly {
    override val attributeName: Name =
      zio.aws.forecast.model.primitives.Name(impl.attributeName())
    override val operation: zio.aws.forecast.model.Operation =
      zio.aws.forecast.model.Operation.wrap(impl.operation())
    override val value: Double = impl.value(): Double
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.Action
  ): zio.aws.forecast.model.Action.ReadOnly = new Wrapper(impl)
}
