package zio.aws.forecast.model
import scala.jdk.CollectionConverters._
sealed trait AutoMLOverrideStrategy {
  def unwrap
      : software.amazon.awssdk.services.forecast.model.AutoMLOverrideStrategy
}
object AutoMLOverrideStrategy {
  def wrap(
      value: software.amazon.awssdk.services.forecast.model.AutoMLOverrideStrategy
  ): zio.aws.forecast.model.AutoMLOverrideStrategy = value match {
    case software.amazon.awssdk.services.forecast.model.AutoMLOverrideStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.forecast.model.AutoMLOverrideStrategy.LATENCY_OPTIMIZED =>
      val r = LatencyOptimized
      r
    case software.amazon.awssdk.services.forecast.model.AutoMLOverrideStrategy.ACCURACY_OPTIMIZED =>
      val r = AccuracyOptimized
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.forecast.model.AutoMLOverrideStrategy {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.AutoMLOverrideStrategy =
      software.amazon.awssdk.services.forecast.model.AutoMLOverrideStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object LatencyOptimized
      extends zio.aws.forecast.model.AutoMLOverrideStrategy {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.AutoMLOverrideStrategy =
      software.amazon.awssdk.services.forecast.model.AutoMLOverrideStrategy.LATENCY_OPTIMIZED
  }
  case object AccuracyOptimized
      extends zio.aws.forecast.model.AutoMLOverrideStrategy {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.AutoMLOverrideStrategy =
      software.amazon.awssdk.services.forecast.model.AutoMLOverrideStrategy.ACCURACY_OPTIMIZED
  }
}
