package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDatasetGroupResponse(
    datasetGroupArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreateDatasetGroupResponse = {
    import CreateDatasetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreateDatasetGroupResponse
      .builder()
      .optionallyWith(
        datasetGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetGroupArn)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.CreateDatasetGroupResponse.ReadOnly =
    zio.aws.forecast.model.CreateDatasetGroupResponse.wrap(buildAwsValue())
}
object CreateDatasetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreateDatasetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreateDatasetGroupResponse =
      zio.aws.forecast.model
        .CreateDatasetGroupResponse(datasetGroupArn.map(value => value))
    def datasetGroupArn: Optional[Arn]
    def getDatasetGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetGroupArn", datasetGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreateDatasetGroupResponse
  ) extends zio.aws.forecast.model.CreateDatasetGroupResponse.ReadOnly {
    override val datasetGroupArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetGroupArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreateDatasetGroupResponse
  ): zio.aws.forecast.model.CreateDatasetGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
