package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{
  UseGeolocationForTimeZone,
  Arn,
  GeolocationFormat,
  TimeZone,
  TimestampFormat,
  Name,
  Format
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDatasetImportJobRequest(
    datasetImportJobName: Name,
    datasetArn: Arn,
    dataSource: zio.aws.forecast.model.DataSource,
    timestampFormat: Optional[TimestampFormat] = Optional.Absent,
    timeZone: Optional[TimeZone] = Optional.Absent,
    useGeolocationForTimeZone: Optional[UseGeolocationForTimeZone] =
      Optional.Absent,
    geolocationFormat: Optional[GeolocationFormat] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.forecast.model.Tag]] = Optional.Absent,
    format: Optional[Format] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreateDatasetImportJobRequest = {
    import CreateDatasetImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreateDatasetImportJobRequest
      .builder()
      .datasetImportJobName(Name.unwrap(datasetImportJobName): java.lang.String)
      .datasetArn(Arn.unwrap(datasetArn): java.lang.String)
      .dataSource(dataSource.buildAwsValue())
      .optionallyWith(
        timestampFormat.map(value =>
          TimestampFormat.unwrap(value): java.lang.String
        )
      )(_.timestampFormat)
      .optionallyWith(
        timeZone.map(value => TimeZone.unwrap(value): java.lang.String)
      )(_.timeZone)
      .optionallyWith(
        useGeolocationForTimeZone.map(value =>
          UseGeolocationForTimeZone.unwrap(value): java.lang.Boolean
        )
      )(_.useGeolocationForTimeZone)
      .optionallyWith(
        geolocationFormat.map(value =>
          GeolocationFormat.unwrap(value): java.lang.String
        )
      )(_.geolocationFormat)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        format.map(value => Format.unwrap(value): java.lang.String)
      )(_.format)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.CreateDatasetImportJobRequest.ReadOnly =
    zio.aws.forecast.model.CreateDatasetImportJobRequest.wrap(buildAwsValue())
}
object CreateDatasetImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreateDatasetImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreateDatasetImportJobRequest =
      zio.aws.forecast.model.CreateDatasetImportJobRequest(
        datasetImportJobName,
        datasetArn,
        dataSource.asEditable,
        timestampFormat.map(value => value),
        timeZone.map(value => value),
        useGeolocationForTimeZone.map(value => value),
        geolocationFormat.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        format.map(value => value)
      )
    def datasetImportJobName: Name
    def datasetArn: Arn
    def dataSource: zio.aws.forecast.model.DataSource.ReadOnly
    def timestampFormat: Optional[TimestampFormat]
    def timeZone: Optional[TimeZone]
    def useGeolocationForTimeZone: Optional[UseGeolocationForTimeZone]
    def geolocationFormat: Optional[GeolocationFormat]
    def tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]]
    def format: Optional[Format]
    def getDatasetImportJobName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(datasetImportJobName)
    def getDatasetArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(datasetArn)
    def getDataSource
        : ZIO[Any, Nothing, zio.aws.forecast.model.DataSource.ReadOnly] =
      ZIO.succeed(dataSource)
    def getTimestampFormat: ZIO[Any, AwsError, TimestampFormat] =
      AwsError.unwrapOptionField("timestampFormat", timestampFormat)
    def getTimeZone: ZIO[Any, AwsError, TimeZone] =
      AwsError.unwrapOptionField("timeZone", timeZone)
    def getUseGeolocationForTimeZone
        : ZIO[Any, AwsError, UseGeolocationForTimeZone] = AwsError
      .unwrapOptionField("useGeolocationForTimeZone", useGeolocationForTimeZone)
    def getGeolocationFormat: ZIO[Any, AwsError, GeolocationFormat] =
      AwsError.unwrapOptionField("geolocationFormat", geolocationFormat)
    def getTags: ZIO[Any, AwsError, List[zio.aws.forecast.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getFormat: ZIO[Any, AwsError, Format] =
      AwsError.unwrapOptionField("format", format)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreateDatasetImportJobRequest
  ) extends zio.aws.forecast.model.CreateDatasetImportJobRequest.ReadOnly {
    override val datasetImportJobName: Name =
      zio.aws.forecast.model.primitives.Name(impl.datasetImportJobName())
    override val datasetArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.datasetArn())
    override val dataSource: zio.aws.forecast.model.DataSource.ReadOnly =
      zio.aws.forecast.model.DataSource.wrap(impl.dataSource())
    override val timestampFormat: Optional[TimestampFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timestampFormat())
        .map(value => zio.aws.forecast.model.primitives.TimestampFormat(value))
    override val timeZone: Optional[TimeZone] = zio.aws.core.internal
      .optionalFromNullable(impl.timeZone())
      .map(value => zio.aws.forecast.model.primitives.TimeZone(value))
    override val useGeolocationForTimeZone
        : Optional[UseGeolocationForTimeZone] = zio.aws.core.internal
      .optionalFromNullable(impl.useGeolocationForTimeZone())
      .map(value =>
        zio.aws.forecast.model.primitives.UseGeolocationForTimeZone(value)
      )
    override val geolocationFormat: Optional[GeolocationFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geolocationFormat())
        .map(value =>
          zio.aws.forecast.model.primitives.GeolocationFormat(value)
        )
    override val tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.Tag.wrap(item)
          }.toList
        )
    override val format: Optional[Format] = zio.aws.core.internal
      .optionalFromNullable(impl.format())
      .map(value => zio.aws.forecast.model.primitives.Format(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreateDatasetImportJobRequest
  ): zio.aws.forecast.model.CreateDatasetImportJobRequest.ReadOnly =
    new Wrapper(impl)
}
