package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDatasetImportJobResponse(
    datasetImportJobArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreateDatasetImportJobResponse = {
    import CreateDatasetImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreateDatasetImportJobResponse
      .builder()
      .optionallyWith(
        datasetImportJobArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetImportJobArn)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.CreateDatasetImportJobResponse.ReadOnly =
    zio.aws.forecast.model.CreateDatasetImportJobResponse.wrap(buildAwsValue())
}
object CreateDatasetImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreateDatasetImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreateDatasetImportJobResponse =
      zio.aws.forecast.model
        .CreateDatasetImportJobResponse(datasetImportJobArn.map(value => value))
    def datasetImportJobArn: Optional[Arn]
    def getDatasetImportJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetImportJobArn", datasetImportJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreateDatasetImportJobResponse
  ) extends zio.aws.forecast.model.CreateDatasetImportJobResponse.ReadOnly {
    override val datasetImportJobArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetImportJobArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreateDatasetImportJobResponse
  ): zio.aws.forecast.model.CreateDatasetImportJobResponse.ReadOnly =
    new Wrapper(impl)
}
