package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateForecastExportJobResponse(
    forecastExportJobArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreateForecastExportJobResponse = {
    import CreateForecastExportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreateForecastExportJobResponse
      .builder()
      .optionallyWith(
        forecastExportJobArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.forecastExportJobArn)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.CreateForecastExportJobResponse.ReadOnly =
    zio.aws.forecast.model.CreateForecastExportJobResponse.wrap(buildAwsValue())
}
object CreateForecastExportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreateForecastExportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreateForecastExportJobResponse =
      zio.aws.forecast.model.CreateForecastExportJobResponse(
        forecastExportJobArn.map(value => value)
      )
    def forecastExportJobArn: Optional[Arn]
    def getForecastExportJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("forecastExportJobArn", forecastExportJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreateForecastExportJobResponse
  ) extends zio.aws.forecast.model.CreateForecastExportJobResponse.ReadOnly {
    override val forecastExportJobArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.forecastExportJobArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreateForecastExportJobResponse
  ): zio.aws.forecast.model.CreateForecastExportJobResponse.ReadOnly =
    new Wrapper(impl)
}
