package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreatePredictorBacktestExportJobResponse(
    predictorBacktestExportJobArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreatePredictorBacktestExportJobResponse = {
    import CreatePredictorBacktestExportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreatePredictorBacktestExportJobResponse
      .builder()
      .optionallyWith(
        predictorBacktestExportJobArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.predictorBacktestExportJobArn)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.CreatePredictorBacktestExportJobResponse.ReadOnly =
    zio.aws.forecast.model.CreatePredictorBacktestExportJobResponse
      .wrap(buildAwsValue())
}
object CreatePredictorBacktestExportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreatePredictorBacktestExportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.forecast.model.CreatePredictorBacktestExportJobResponse =
      zio.aws.forecast.model.CreatePredictorBacktestExportJobResponse(
        predictorBacktestExportJobArn.map(value => value)
      )
    def predictorBacktestExportJobArn: Optional[Arn]
    def getPredictorBacktestExportJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField(
        "predictorBacktestExportJobArn",
        predictorBacktestExportJobArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreatePredictorBacktestExportJobResponse
  ) extends zio.aws.forecast.model.CreatePredictorBacktestExportJobResponse.ReadOnly {
    override val predictorBacktestExportJobArn: Optional[Arn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.predictorBacktestExportJobArn())
        .map(value => zio.aws.forecast.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreatePredictorBacktestExportJobResponse
  ): zio.aws.forecast.model.CreatePredictorBacktestExportJobResponse.ReadOnly =
    new Wrapper(impl)
}
