package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{Arn, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateWhatIfAnalysisRequest(
    whatIfAnalysisName: Name,
    forecastArn: Arn,
    timeSeriesSelector: Optional[zio.aws.forecast.model.TimeSeriesSelector] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.forecast.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreateWhatIfAnalysisRequest = {
    import CreateWhatIfAnalysisRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreateWhatIfAnalysisRequest
      .builder()
      .whatIfAnalysisName(Name.unwrap(whatIfAnalysisName): java.lang.String)
      .forecastArn(Arn.unwrap(forecastArn): java.lang.String)
      .optionallyWith(timeSeriesSelector.map(value => value.buildAwsValue()))(
        _.timeSeriesSelector
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.CreateWhatIfAnalysisRequest.ReadOnly =
    zio.aws.forecast.model.CreateWhatIfAnalysisRequest.wrap(buildAwsValue())
}
object CreateWhatIfAnalysisRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreateWhatIfAnalysisRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreateWhatIfAnalysisRequest =
      zio.aws.forecast.model.CreateWhatIfAnalysisRequest(
        whatIfAnalysisName,
        forecastArn,
        timeSeriesSelector.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def whatIfAnalysisName: Name
    def forecastArn: Arn
    def timeSeriesSelector
        : Optional[zio.aws.forecast.model.TimeSeriesSelector.ReadOnly]
    def tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]]
    def getWhatIfAnalysisName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(whatIfAnalysisName)
    def getForecastArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(forecastArn)
    def getTimeSeriesSelector: ZIO[
      Any,
      AwsError,
      zio.aws.forecast.model.TimeSeriesSelector.ReadOnly
    ] = AwsError.unwrapOptionField("timeSeriesSelector", timeSeriesSelector)
    def getTags: ZIO[Any, AwsError, List[zio.aws.forecast.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreateWhatIfAnalysisRequest
  ) extends zio.aws.forecast.model.CreateWhatIfAnalysisRequest.ReadOnly {
    override val whatIfAnalysisName: Name =
      zio.aws.forecast.model.primitives.Name(impl.whatIfAnalysisName())
    override val forecastArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.forecastArn())
    override val timeSeriesSelector
        : Optional[zio.aws.forecast.model.TimeSeriesSelector.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeSeriesSelector())
        .map(value => zio.aws.forecast.model.TimeSeriesSelector.wrap(value))
    override val tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreateWhatIfAnalysisRequest
  ): zio.aws.forecast.model.CreateWhatIfAnalysisRequest.ReadOnly = new Wrapper(
    impl
  )
}
