package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateWhatIfAnalysisResponse(
    whatIfAnalysisArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreateWhatIfAnalysisResponse = {
    import CreateWhatIfAnalysisResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreateWhatIfAnalysisResponse
      .builder()
      .optionallyWith(
        whatIfAnalysisArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.whatIfAnalysisArn)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.CreateWhatIfAnalysisResponse.ReadOnly =
    zio.aws.forecast.model.CreateWhatIfAnalysisResponse.wrap(buildAwsValue())
}
object CreateWhatIfAnalysisResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreateWhatIfAnalysisResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreateWhatIfAnalysisResponse =
      zio.aws.forecast.model
        .CreateWhatIfAnalysisResponse(whatIfAnalysisArn.map(value => value))
    def whatIfAnalysisArn: Optional[Arn]
    def getWhatIfAnalysisArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("whatIfAnalysisArn", whatIfAnalysisArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreateWhatIfAnalysisResponse
  ) extends zio.aws.forecast.model.CreateWhatIfAnalysisResponse.ReadOnly {
    override val whatIfAnalysisArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.whatIfAnalysisArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreateWhatIfAnalysisResponse
  ): zio.aws.forecast.model.CreateWhatIfAnalysisResponse.ReadOnly = new Wrapper(
    impl
  )
}
