package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.LongArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateWhatIfForecastExportResponse(
    whatIfForecastExportArn: Optional[LongArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastExportResponse = {
    import CreateWhatIfForecastExportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastExportResponse
      .builder()
      .optionallyWith(
        whatIfForecastExportArn.map(value =>
          LongArn.unwrap(value): java.lang.String
        )
      )(_.whatIfForecastExportArn)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.CreateWhatIfForecastExportResponse.ReadOnly =
    zio.aws.forecast.model.CreateWhatIfForecastExportResponse
      .wrap(buildAwsValue())
}
object CreateWhatIfForecastExportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastExportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreateWhatIfForecastExportResponse =
      zio.aws.forecast.model.CreateWhatIfForecastExportResponse(
        whatIfForecastExportArn.map(value => value)
      )
    def whatIfForecastExportArn: Optional[LongArn]
    def getWhatIfForecastExportArn: ZIO[Any, AwsError, LongArn] = AwsError
      .unwrapOptionField("whatIfForecastExportArn", whatIfForecastExportArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastExportResponse
  ) extends zio.aws.forecast.model.CreateWhatIfForecastExportResponse.ReadOnly {
    override val whatIfForecastExportArn: Optional[LongArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.whatIfForecastExportArn())
        .map(value => zio.aws.forecast.model.primitives.LongArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastExportResponse
  ): zio.aws.forecast.model.CreateWhatIfForecastExportResponse.ReadOnly =
    new Wrapper(impl)
}
