package zio.aws.forecast.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DataDestination(s3Config: zio.aws.forecast.model.S3Config) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DataDestination = {
    import DataDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DataDestination
      .builder()
      .s3Config(s3Config.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DataDestination.ReadOnly =
    zio.aws.forecast.model.DataDestination.wrap(buildAwsValue())
}
object DataDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DataDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DataDestination =
      zio.aws.forecast.model.DataDestination(s3Config.asEditable)
    def s3Config: zio.aws.forecast.model.S3Config.ReadOnly
    def getS3Config
        : ZIO[Any, Nothing, zio.aws.forecast.model.S3Config.ReadOnly] =
      ZIO.succeed(s3Config)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DataDestination
  ) extends zio.aws.forecast.model.DataDestination.ReadOnly {
    override val s3Config: zio.aws.forecast.model.S3Config.ReadOnly =
      zio.aws.forecast.model.S3Config.wrap(impl.s3Config())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DataDestination
  ): zio.aws.forecast.model.DataDestination.ReadOnly = new Wrapper(impl)
}
