package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteForecastRequest(forecastArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DeleteForecastRequest = {
    import DeleteForecastRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DeleteForecastRequest
      .builder()
      .forecastArn(Arn.unwrap(forecastArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DeleteForecastRequest.ReadOnly =
    zio.aws.forecast.model.DeleteForecastRequest.wrap(buildAwsValue())
}
object DeleteForecastRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DeleteForecastRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DeleteForecastRequest =
      zio.aws.forecast.model.DeleteForecastRequest(forecastArn)
    def forecastArn: Arn
    def getForecastArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(forecastArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DeleteForecastRequest
  ) extends zio.aws.forecast.model.DeleteForecastRequest.ReadOnly {
    override val forecastArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.forecastArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DeleteForecastRequest
  ): zio.aws.forecast.model.DeleteForecastRequest.ReadOnly = new Wrapper(impl)
}
