package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeletePredictorBacktestExportJobRequest(
    predictorBacktestExportJobArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DeletePredictorBacktestExportJobRequest = {
    import DeletePredictorBacktestExportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DeletePredictorBacktestExportJobRequest
      .builder()
      .predictorBacktestExportJobArn(
        Arn.unwrap(predictorBacktestExportJobArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.DeletePredictorBacktestExportJobRequest.ReadOnly =
    zio.aws.forecast.model.DeletePredictorBacktestExportJobRequest
      .wrap(buildAwsValue())
}
object DeletePredictorBacktestExportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DeletePredictorBacktestExportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.forecast.model.DeletePredictorBacktestExportJobRequest =
      zio.aws.forecast.model
        .DeletePredictorBacktestExportJobRequest(predictorBacktestExportJobArn)
    def predictorBacktestExportJobArn: Arn
    def getPredictorBacktestExportJobArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(predictorBacktestExportJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DeletePredictorBacktestExportJobRequest
  ) extends zio.aws.forecast.model.DeletePredictorBacktestExportJobRequest.ReadOnly {
    override val predictorBacktestExportJobArn: Arn =
      zio.aws.forecast.model.primitives
        .Arn(impl.predictorBacktestExportJobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DeletePredictorBacktestExportJobRequest
  ): zio.aws.forecast.model.DeletePredictorBacktestExportJobRequest.ReadOnly =
    new Wrapper(impl)
}
