package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeDatasetRequest(datasetArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribeDatasetRequest = {
    import DescribeDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribeDatasetRequest
      .builder()
      .datasetArn(Arn.unwrap(datasetArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DescribeDatasetRequest.ReadOnly =
    zio.aws.forecast.model.DescribeDatasetRequest.wrap(buildAwsValue())
}
object DescribeDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribeDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DescribeDatasetRequest =
      zio.aws.forecast.model.DescribeDatasetRequest(datasetArn)
    def datasetArn: Arn
    def getDatasetArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(datasetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribeDatasetRequest
  ) extends zio.aws.forecast.model.DescribeDatasetRequest.ReadOnly {
    override val datasetArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.datasetArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribeDatasetRequest
  ): zio.aws.forecast.model.DescribeDatasetRequest.ReadOnly = new Wrapper(impl)
}
