package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{
  Status,
  Message,
  Timestamp,
  Arn,
  Name,
  Format
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribePredictorBacktestExportJobResponse(
    predictorBacktestExportJobArn: Optional[Arn] = Optional.Absent,
    predictorBacktestExportJobName: Optional[Name] = Optional.Absent,
    predictorArn: Optional[Arn] = Optional.Absent,
    destination: Optional[zio.aws.forecast.model.DataDestination] =
      Optional.Absent,
    message: Optional[Message] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent,
    format: Optional[Format] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribePredictorBacktestExportJobResponse = {
    import DescribePredictorBacktestExportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribePredictorBacktestExportJobResponse
      .builder()
      .optionallyWith(
        predictorBacktestExportJobArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.predictorBacktestExportJobArn)
      .optionallyWith(
        predictorBacktestExportJobName.map(value =>
          Name.unwrap(value): java.lang.String
        )
      )(_.predictorBacktestExportJobName)
      .optionallyWith(
        predictorArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.predictorArn)
      .optionallyWith(destination.map(value => value.buildAwsValue()))(
        _.destination
      )
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .optionallyWith(
        format.map(value => Format.unwrap(value): java.lang.String)
      )(_.format)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.DescribePredictorBacktestExportJobResponse.ReadOnly =
    zio.aws.forecast.model.DescribePredictorBacktestExportJobResponse
      .wrap(buildAwsValue())
}
object DescribePredictorBacktestExportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribePredictorBacktestExportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.forecast.model.DescribePredictorBacktestExportJobResponse =
      zio.aws.forecast.model.DescribePredictorBacktestExportJobResponse(
        predictorBacktestExportJobArn.map(value => value),
        predictorBacktestExportJobName.map(value => value),
        predictorArn.map(value => value),
        destination.map(value => value.asEditable),
        message.map(value => value),
        status.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value),
        format.map(value => value)
      )
    def predictorBacktestExportJobArn: Optional[Arn]
    def predictorBacktestExportJobName: Optional[Name]
    def predictorArn: Optional[Arn]
    def destination: Optional[zio.aws.forecast.model.DataDestination.ReadOnly]
    def message: Optional[Message]
    def status: Optional[Status]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def format: Optional[Format]
    def getPredictorBacktestExportJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField(
        "predictorBacktestExportJobArn",
        predictorBacktestExportJobArn
      )
    def getPredictorBacktestExportJobName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField(
        "predictorBacktestExportJobName",
        predictorBacktestExportJobName
      )
    def getPredictorArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("predictorArn", predictorArn)
    def getDestination
        : ZIO[Any, AwsError, zio.aws.forecast.model.DataDestination.ReadOnly] =
      AwsError.unwrapOptionField("destination", destination)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
    def getFormat: ZIO[Any, AwsError, Format] =
      AwsError.unwrapOptionField("format", format)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribePredictorBacktestExportJobResponse
  ) extends zio.aws.forecast.model.DescribePredictorBacktestExportJobResponse.ReadOnly {
    override val predictorBacktestExportJobArn: Optional[Arn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.predictorBacktestExportJobArn())
        .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val predictorBacktestExportJobName: Optional[Name] =
      zio.aws.core.internal
        .optionalFromNullable(impl.predictorBacktestExportJobName())
        .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val predictorArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.predictorArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val destination
        : Optional[zio.aws.forecast.model.DataDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destination())
        .map(value => zio.aws.forecast.model.DataDestination.wrap(value))
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.forecast.model.primitives.Message(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.forecast.model.primitives.Status(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val format: Optional[Format] = zio.aws.core.internal
      .optionalFromNullable(impl.format())
      .map(value => zio.aws.forecast.model.primitives.Format(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribePredictorBacktestExportJobResponse
  ): zio.aws.forecast.model.DescribePredictorBacktestExportJobResponse.ReadOnly =
    new Wrapper(impl)
}
