package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeWhatIfAnalysisRequest(whatIfAnalysisArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribeWhatIfAnalysisRequest = {
    import DescribeWhatIfAnalysisRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribeWhatIfAnalysisRequest
      .builder()
      .whatIfAnalysisArn(Arn.unwrap(whatIfAnalysisArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.DescribeWhatIfAnalysisRequest.ReadOnly =
    zio.aws.forecast.model.DescribeWhatIfAnalysisRequest.wrap(buildAwsValue())
}
object DescribeWhatIfAnalysisRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribeWhatIfAnalysisRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DescribeWhatIfAnalysisRequest =
      zio.aws.forecast.model.DescribeWhatIfAnalysisRequest(whatIfAnalysisArn)
    def whatIfAnalysisArn: Arn
    def getWhatIfAnalysisArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(whatIfAnalysisArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribeWhatIfAnalysisRequest
  ) extends zio.aws.forecast.model.DescribeWhatIfAnalysisRequest.ReadOnly {
    override val whatIfAnalysisArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.whatIfAnalysisArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribeWhatIfAnalysisRequest
  ): zio.aws.forecast.model.DescribeWhatIfAnalysisRequest.ReadOnly =
    new Wrapper(impl)
}
