package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{
  Status,
  LongArn,
  Message,
  Timestamp,
  Name,
  Format
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeWhatIfForecastExportResponse(
    whatIfForecastExportArn: Optional[LongArn] = Optional.Absent,
    whatIfForecastExportName: Optional[Name] = Optional.Absent,
    whatIfForecastArns: Optional[Iterable[LongArn]] = Optional.Absent,
    destination: Optional[zio.aws.forecast.model.DataDestination] =
      Optional.Absent,
    message: Optional[Message] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    estimatedTimeRemainingInMinutes: Optional[Long] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent,
    format: Optional[Format] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastExportResponse = {
    import DescribeWhatIfForecastExportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastExportResponse
      .builder()
      .optionallyWith(
        whatIfForecastExportArn.map(value =>
          LongArn.unwrap(value): java.lang.String
        )
      )(_.whatIfForecastExportArn)
      .optionallyWith(
        whatIfForecastExportName.map(value =>
          Name.unwrap(value): java.lang.String
        )
      )(_.whatIfForecastExportName)
      .optionallyWith(
        whatIfForecastArns.map(value =>
          value.map { item =>
            LongArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.whatIfForecastArns)
      .optionallyWith(destination.map(value => value.buildAwsValue()))(
        _.destination
      )
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        estimatedTimeRemainingInMinutes.map(value => value: java.lang.Long)
      )(_.estimatedTimeRemainingInMinutes)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .optionallyWith(
        format.map(value => Format.unwrap(value): java.lang.String)
      )(_.format)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.DescribeWhatIfForecastExportResponse.ReadOnly =
    zio.aws.forecast.model.DescribeWhatIfForecastExportResponse
      .wrap(buildAwsValue())
}
object DescribeWhatIfForecastExportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastExportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.forecast.model.DescribeWhatIfForecastExportResponse =
      zio.aws.forecast.model.DescribeWhatIfForecastExportResponse(
        whatIfForecastExportArn.map(value => value),
        whatIfForecastExportName.map(value => value),
        whatIfForecastArns.map(value => value),
        destination.map(value => value.asEditable),
        message.map(value => value),
        status.map(value => value),
        creationTime.map(value => value),
        estimatedTimeRemainingInMinutes.map(value => value),
        lastModificationTime.map(value => value),
        format.map(value => value)
      )
    def whatIfForecastExportArn: Optional[LongArn]
    def whatIfForecastExportName: Optional[Name]
    def whatIfForecastArns: Optional[List[LongArn]]
    def destination: Optional[zio.aws.forecast.model.DataDestination.ReadOnly]
    def message: Optional[Message]
    def status: Optional[Status]
    def creationTime: Optional[Timestamp]
    def estimatedTimeRemainingInMinutes: Optional[Long]
    def lastModificationTime: Optional[Timestamp]
    def format: Optional[Format]
    def getWhatIfForecastExportArn: ZIO[Any, AwsError, LongArn] = AwsError
      .unwrapOptionField("whatIfForecastExportArn", whatIfForecastExportArn)
    def getWhatIfForecastExportName: ZIO[Any, AwsError, Name] = AwsError
      .unwrapOptionField("whatIfForecastExportName", whatIfForecastExportName)
    def getWhatIfForecastArns: ZIO[Any, AwsError, List[LongArn]] =
      AwsError.unwrapOptionField("whatIfForecastArns", whatIfForecastArns)
    def getDestination
        : ZIO[Any, AwsError, zio.aws.forecast.model.DataDestination.ReadOnly] =
      AwsError.unwrapOptionField("destination", destination)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getEstimatedTimeRemainingInMinutes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "estimatedTimeRemainingInMinutes",
        estimatedTimeRemainingInMinutes
      )
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
    def getFormat: ZIO[Any, AwsError, Format] =
      AwsError.unwrapOptionField("format", format)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastExportResponse
  ) extends zio.aws.forecast.model.DescribeWhatIfForecastExportResponse.ReadOnly {
    override val whatIfForecastExportArn: Optional[LongArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.whatIfForecastExportArn())
        .map(value => zio.aws.forecast.model.primitives.LongArn(value))
    override val whatIfForecastExportName: Optional[Name] =
      zio.aws.core.internal
        .optionalFromNullable(impl.whatIfForecastExportName())
        .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val whatIfForecastArns: Optional[List[LongArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.whatIfForecastArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.primitives.LongArn(item)
          }.toList
        )
    override val destination
        : Optional[zio.aws.forecast.model.DataDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destination())
        .map(value => zio.aws.forecast.model.DataDestination.wrap(value))
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.forecast.model.primitives.Message(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.forecast.model.primitives.Status(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val estimatedTimeRemainingInMinutes: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.estimatedTimeRemainingInMinutes())
        .map(value => value: Long)
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val format: Optional[Format] = zio.aws.core.internal
      .optionalFromNullable(impl.format())
      .map(value => zio.aws.forecast.model.primitives.Format(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastExportResponse
  ): zio.aws.forecast.model.DescribeWhatIfForecastExportResponse.ReadOnly =
    new Wrapper(impl)
}
