package zio.aws.forecast.model
import scala.jdk.CollectionConverters._
sealed trait FilterConditionString {
  def unwrap
      : software.amazon.awssdk.services.forecast.model.FilterConditionString
}
object FilterConditionString {
  def wrap(
      value: software.amazon.awssdk.services.forecast.model.FilterConditionString
  ): zio.aws.forecast.model.FilterConditionString = value match {
    case software.amazon.awssdk.services.forecast.model.FilterConditionString.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.forecast.model.FilterConditionString.IS =>
      val r = IS
      r
    case software.amazon.awssdk.services.forecast.model.FilterConditionString.IS_NOT =>
      val r = IS_NOT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.forecast.model.FilterConditionString {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.FilterConditionString =
      software.amazon.awssdk.services.forecast.model.FilterConditionString.UNKNOWN_TO_SDK_VERSION
  }
  case object IS extends zio.aws.forecast.model.FilterConditionString {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.FilterConditionString =
      software.amazon.awssdk.services.forecast.model.FilterConditionString.IS
  }
  case object IS_NOT extends zio.aws.forecast.model.FilterConditionString {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.FilterConditionString =
      software.amazon.awssdk.services.forecast.model.FilterConditionString.IS_NOT
  }
}
