package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{Integer, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IntegerParameterRange(
    name: Name,
    maxValue: Integer,
    minValue: Integer,
    scalingType: Optional[zio.aws.forecast.model.ScalingType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.IntegerParameterRange = {
    import IntegerParameterRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.IntegerParameterRange
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .maxValue(maxValue: java.lang.Integer)
      .minValue(minValue: java.lang.Integer)
      .optionallyWith(scalingType.map(value => value.unwrap))(_.scalingType)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.IntegerParameterRange.ReadOnly =
    zio.aws.forecast.model.IntegerParameterRange.wrap(buildAwsValue())
}
object IntegerParameterRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.IntegerParameterRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.IntegerParameterRange =
      zio.aws.forecast.model.IntegerParameterRange(
        name,
        maxValue,
        minValue,
        scalingType.map(value => value)
      )
    def name: Name
    def maxValue: Integer
    def minValue: Integer
    def scalingType: Optional[zio.aws.forecast.model.ScalingType]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getMaxValue: ZIO[Any, Nothing, Integer] = ZIO.succeed(maxValue)
    def getMinValue: ZIO[Any, Nothing, Integer] = ZIO.succeed(minValue)
    def getScalingType: ZIO[Any, AwsError, zio.aws.forecast.model.ScalingType] =
      AwsError.unwrapOptionField("scalingType", scalingType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.IntegerParameterRange
  ) extends zio.aws.forecast.model.IntegerParameterRange.ReadOnly {
    override val name: Name =
      zio.aws.forecast.model.primitives.Name(impl.name())
    override val maxValue: Integer = impl.maxValue(): Integer
    override val minValue: Integer = impl.minValue(): Integer
    override val scalingType: Optional[zio.aws.forecast.model.ScalingType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scalingType())
        .map(value => zio.aws.forecast.model.ScalingType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.IntegerParameterRange
  ): zio.aws.forecast.model.IntegerParameterRange.ReadOnly = new Wrapper(impl)
}
