package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListWhatIfForecastExportsResponse(
    whatIfForecastExports: Optional[
      Iterable[zio.aws.forecast.model.WhatIfForecastExportSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ListWhatIfForecastExportsResponse = {
    import ListWhatIfForecastExportsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ListWhatIfForecastExportsResponse
      .builder()
      .optionallyWith(
        whatIfForecastExports.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.whatIfForecastExports)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.ListWhatIfForecastExportsResponse.ReadOnly =
    zio.aws.forecast.model.ListWhatIfForecastExportsResponse
      .wrap(buildAwsValue())
}
object ListWhatIfForecastExportsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ListWhatIfForecastExportsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.ListWhatIfForecastExportsResponse =
      zio.aws.forecast.model.ListWhatIfForecastExportsResponse(
        whatIfForecastExports.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def whatIfForecastExports: Optional[
      List[zio.aws.forecast.model.WhatIfForecastExportSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getWhatIfForecastExports: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.WhatIfForecastExportSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("whatIfForecastExports", whatIfForecastExports)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ListWhatIfForecastExportsResponse
  ) extends zio.aws.forecast.model.ListWhatIfForecastExportsResponse.ReadOnly {
    override val whatIfForecastExports: Optional[
      List[zio.aws.forecast.model.WhatIfForecastExportSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.whatIfForecastExports())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.forecast.model.WhatIfForecastExportSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.forecast.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ListWhatIfForecastExportsResponse
  ): zio.aws.forecast.model.ListWhatIfForecastExportsResponse.ReadOnly =
    new Wrapper(impl)
}
