package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.MetricName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MetricResult(
    metricName: Optional[MetricName] = Optional.Absent,
    metricValue: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.MetricResult = {
    import MetricResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.MetricResult
      .builder()
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(metricValue.map(value => value: java.lang.Double))(
        _.metricValue
      )
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.MetricResult.ReadOnly =
    zio.aws.forecast.model.MetricResult.wrap(buildAwsValue())
}
object MetricResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.MetricResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.MetricResult =
      zio.aws.forecast.model.MetricResult(
        metricName.map(value => value),
        metricValue.map(value => value)
      )
    def metricName: Optional[MetricName]
    def metricValue: Optional[Double]
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getMetricValue: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("metricValue", metricValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.MetricResult
  ) extends zio.aws.forecast.model.MetricResult.ReadOnly {
    override val metricName: Optional[MetricName] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value => zio.aws.forecast.model.primitives.MetricName(value))
    override val metricValue: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.metricValue())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.MetricResult
  ): zio.aws.forecast.model.MetricResult.ReadOnly = new Wrapper(impl)
}
