package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{
  Status,
  ErrorMessage,
  Timestamp,
  Arn,
  Name
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class PredictorSummary(
    predictorArn: Optional[Arn] = Optional.Absent,
    predictorName: Optional[Name] = Optional.Absent,
    datasetGroupArn: Optional[Arn] = Optional.Absent,
    isAutoPredictor: Optional[Boolean] = Optional.Absent,
    referencePredictorSummary: Optional[
      zio.aws.forecast.model.ReferencePredictorSummary
    ] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    message: Optional[ErrorMessage] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.PredictorSummary = {
    import PredictorSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.PredictorSummary
      .builder()
      .optionallyWith(
        predictorArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.predictorArn)
      .optionallyWith(
        predictorName.map(value => Name.unwrap(value): java.lang.String)
      )(_.predictorName)
      .optionallyWith(
        datasetGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetGroupArn)
      .optionallyWith(isAutoPredictor.map(value => value: java.lang.Boolean))(
        _.isAutoPredictor
      )
      .optionallyWith(
        referencePredictorSummary.map(value => value.buildAwsValue())
      )(_.referencePredictorSummary)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.PredictorSummary.ReadOnly =
    zio.aws.forecast.model.PredictorSummary.wrap(buildAwsValue())
}
object PredictorSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.PredictorSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.PredictorSummary =
      zio.aws.forecast.model.PredictorSummary(
        predictorArn.map(value => value),
        predictorName.map(value => value),
        datasetGroupArn.map(value => value),
        isAutoPredictor.map(value => value),
        referencePredictorSummary.map(value => value.asEditable),
        status.map(value => value),
        message.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value)
      )
    def predictorArn: Optional[Arn]
    def predictorName: Optional[Name]
    def datasetGroupArn: Optional[Arn]
    def isAutoPredictor: Optional[Boolean]
    def referencePredictorSummary
        : Optional[zio.aws.forecast.model.ReferencePredictorSummary.ReadOnly]
    def status: Optional[Status]
    def message: Optional[ErrorMessage]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def getPredictorArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("predictorArn", predictorArn)
    def getPredictorName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("predictorName", predictorName)
    def getDatasetGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetGroupArn", datasetGroupArn)
    def getIsAutoPredictor: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAutoPredictor", isAutoPredictor)
    def getReferencePredictorSummary: ZIO[
      Any,
      AwsError,
      zio.aws.forecast.model.ReferencePredictorSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "referencePredictorSummary",
      referencePredictorSummary
    )
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.PredictorSummary
  ) extends zio.aws.forecast.model.PredictorSummary.ReadOnly {
    override val predictorArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.predictorArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val predictorName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.predictorName())
      .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val datasetGroupArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetGroupArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val isAutoPredictor: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isAutoPredictor())
      .map(value => value: Boolean)
    override val referencePredictorSummary
        : Optional[zio.aws.forecast.model.ReferencePredictorSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.referencePredictorSummary())
        .map(value =>
          zio.aws.forecast.model.ReferencePredictorSummary.wrap(value)
        )
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.forecast.model.primitives.Status(value))
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.forecast.model.primitives.ErrorMessage(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.PredictorSummary
  ): zio.aws.forecast.model.PredictorSummary.ReadOnly = new Wrapper(impl)
}
